<?php
/*
 * This file is part of Web Pro Manager.
 * 
 * Web Pro Manager is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Web Pro Manager is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Web Pro Manager.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * @author The Web Pro Miami, Inc. <info@thewebpro.com>
 * @copyright The Web Pro Miami, Inc. <info@thewebpro.com>, http://www.thewebpro.com/
 * @license http://www.gnu.org/licenses/gpl.html GNU GPL
 * @package WebProManager
*/

require("../inc/stop_cache.php");
$nAdminOnlyPg = 0;
require("../inc/secure_page.php");
// connect to mysql
require("../../inc/dbconnect.php");
include("../inc/paginator.php");
//include("../inc/pageutil.php");
include("../inc/calendar.php");
//require("../inc/imgedit.php");
require("../inc/langutil.php");
require("../../inc/tmplutil.php");

$nShowPerPg = 999;

// Get passed-in vars
$nRecID = $_GET["id"];
if(!$nRecID){ $nRecID = $_POST["id"]; }
$nPage = $_GET["pg"]; if(!$nPage){ $nPage = $_POST["pg"]; }
$nSort = $_GET["srt"];
$nSortOrder = $_GET["ord"];
$nShowPerPgOverride = $_GET["spp"];
if($nShowPerPgOverride){ $nShowPerPg = $nShowPerPgOverride; }

// Globals
$nSortableCreateARRAY = array();
$nSortableARRAY = array();
$nOpenerTag="[#"; $nCloserTag="#]"; $nTagParamDelim="_"; $nTagSubParamDelim="=";
?>
<div id="listContent" style="padding-top:0px;">
<?php
$nPassThruReq = "";
$nDivToUpdate = "ajaxPageEdit";
$nPageInDiv = "arrange/page_components.php";
$nCurrQueryStr = $_SERVER['QUERY_STRING'];
if($nCurrQueryStr){ $nFullPageInDiv = $nPageInDiv."?".$nCurrQueryStr; } else { $nFullPageInDiv = $nPageInDiv; }
$nPagingText = nGetPaging($nListingSQL,$nPage,$nShowPerPg,$nPassThru,$nDivToUpdate,$nPageInDiv);
if($nPassThru){ $nPassThruQry="?".$nPassThru; $nPassThru="&".$nPassThru; }
// for extrenal refresh requests
print "<script>refreshPageComps = function(){ loadContent('".$nDivToUpdate."','".$nFullPageInDiv."'); }</script>";
?>
	
<div id="pageEditor">
	
	<?=nGetPageLayoutAndComps();?>
	
</div>

<script type="text/javascript"> 
buildSortables();
function buildSortables(){
	// <![CDATA[ 
	// in your PHP code, make sure to set "dropOnEmpty: true" if pageColumn is empty
	sections = [<? if($nSortableARRAY){ echo implode(",",$nSortableARRAY); } ?>];
	<? if($nSortableCreateARRAY){ echo implode("\n",$nSortableCreateARRAY); } ?>
	// ]]>
}
function setDrop(divName,dropToggle){
	buildSortables();
	Sortable.create(divName,{onUpdate:saveChanges, tag:'div',constraint:false, containment: sections, only:'component', dropOnEmpty: dropToggle});
}
function saveChanges(container){
	var columnID = container.id;
	var pageOrder = Sortable.serialize(container);
	new Ajax.Request("edit/component_order.php", { method: "post", parameters: { PID:<?=$nRecID;?>,CID:columnID,order:pageOrder } });  
	// only if container is empty, allow dropping
	if(Sortable.sequence(container)==""){ setDrop(container.id,true) }
}
</script>

		
<!--[if !IE]>start pagination<![endif]-->
<div class="pagination">
	<span class="page_no">Page 1 of 1</span>
</div>
<!--[if !IE]>end pagination<![endif]-->


<?php
function nGetPageLayoutAndComps(){
	global $nOpenerTag,$nCloserTag,$nTagParamDelim,$nTagSubParamDelim;
	global $nRecID;
	if(!$nRecID){ return; }
	$nCurrentTheme = nGetActiveThemePath();
	$nTmplLayoutPath = "../../tmpl/{$nCurrentTheme}layouts/";
	// Set template file
	$nType = nGetPageType($nRecID);
	switch($nType){
		case "Homepage": $nFileName = "home.html"; break;
		case "Content": $nFileName = "content.html"; break;
		case "Search": $nFileName = "search.html"; break;
		case "Link": $nFileName = ""; break;
	}
	$nFullTmplLayoutPath = "$nTmplLayoutPath$nFileName";
	if(file_exists($nFullTmplLayoutPath) && is_file($nFullTmplLayoutPath)){ $nTemplateCode = file_get_contents($nFullTmplLayoutPath); } else {
		exit("<div align=\"center\" style=\"padding:20px;\">A layout for this template does not exist: $nFullTmplLayoutPath.<BR><BR>Please check your system configuration or switch to a different template.</div>");
	}
	// Parse layout template
	if($nTemplateCode){
		do{
			$nOpenerPos = strpos($nTemplateCode,$nOpenerTag);
			$nCloserPos = strpos($nTemplateCode,$nCloserTag,$nOpenerPos);
			if($nOpenerPos!==false && $nCloserPos!==false){
				$nInnerTag = substr($nTemplateCode,($nOpenerPos+strlen($nOpenerTag)),($nCloserPos-strlen($nCloserTag)-$nOpenerPos));
				$nReplacement = "";
				$nInnerTagARRAY = explode($nTagParamDelim,$nInnerTag);
				$nTemplateItem = $nInnerTagARRAY[0];
				unset($nInnerTagARRAY[0]);
				switch($nTemplateItem){
					case "compColumnComps":
						$nReplacement = managerGetColumnComps($nTemplateItem,$nInnerTagARRAY);
						break;
				}
				$nTemplateCode = str_replace(($nOpenerTag.$nInnerTag.$nCloserTag),$nReplacement,$nTemplateCode);
			}
		} while($nOpenerPos!==false);
	}
	return $nTemplateCode;
}

function nGetActiveThemePath(){
	global $DBName,$Link;
	$nSettingsARRAY = array();
	$nSQL = "SELECT * FROM nSettings WHERE nSetting='activeTemplate'";
	$Result = mysql_db_query ($DBName,$nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nActiveTmplPath = $Row["nValue"];
	}
	return $nActiveTmplPath;
}

function managerGetColumnComps($nItem,$nFullParamARRAY=""){
	global $DBName,$Link,$nTagSubParamDelim,$nRecID;
	$nColumnID = nGetParam("COLID",$nFullParamARRAY);
	$nTitle = nGetParam("TITLE",$nFullParamARRAY);
	if(!$nColumnID || !$nRecID){ return; }
	if(!$nTitle){ $nTitle = "Column $nColumnID"; }
	// Get components for this column
	$nColumnComps = nGetColumn($nColumnID,$nRecID);
	$nColumnCode = "<div id=\"pageColumn_$nColumnID\" class=\"pageColumn\"><h6 class=\"handleCompFalse\">$nTitle</h6>$nColumnComps</div><div style=\"clear:both;\"></div>";
	return $nColumnCode;
}

function nGetColumn($nColumnID,$nPageID){
	global $DBName,$Link;
	global $nSortableCreateARRAY, $nSortableARRAY, $nDefaultLang;
	if($nColumnID===""){ return ""; }
	$nCurrRec = 0;
	$nSQL = "SELECT xComponentPage.nID AS xID,nComponentID,nContentID FROM xComponentPage LEFT JOIN nComponent ON nComponentID=nComponent.nID WHERE nComponent.nActive=1 AND nColumnID=$nColumnID AND nPageID=$nPageID ORDER BY nOrderID";
	$Result = mysql_db_query ($DBName,$nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nCurrRec++;
		$nID = $Row["xID"];
		$nCompID = $Row["nComponentID"];
		$nContentID = $Row["nContentID"];
		$nCompName = nGetComponentName($nCompID);
		$nCompTitle = strip_tags(nGetComponentTitle($nContentID));
		$nCompFile = nGetComponentFile($nCompID);
		$nCompCode = tmplComp("",array("CID=$nContentID","CFILE=$nCompFile","LANG=$nDefaultLang","EDIT=1"));
		$nCompCloneARRAY = nGetComponentCloneARRAY($nID);
		$nCloneAmt = count($nCompCloneARRAY)-1;
		if($nCloneAmt>0 && $nContentID){ $nCompName="$nCompName <a title=\"Cloned on $nCloneAmt other pages.\" style=\"text-decoration:none;\">(clone)</a>"; }
		$nCompName = "<div style=\"padding-left:15px;\"><strong>$nCompName</strong></div>";
		$nTable.= <<<CODE
			<div id="component_$nID" class="component">
				<table width="100%" border="0" cellspacing="0" cellpadding="0" id="componentTable">
				  <tr style="color:#fff;">
					<td id="componentTitle" valign="top" style="padding:2px 0;"><span class="handleComp">$nCompName</span></td>
					<td width="80" align="right" valign="top" style="padding:2px 6px;">
						<a href="dialog/component_edit.php?id=$nID" title="Edit Component" onClick="Modalbox.show(this.href,{title: this.title, width: 800, overlayClose:false}); return false;"><img src="css/layout/edit_module.gif" alt="" width="11" height="11" hspace="3" border="0"></a> 
						<a href="dialog/component_duplicate.php?id=$nID" title="Duplicate Component" onClick="Modalbox.show(this.href,{title: this.title, width: 500, overlayClose:false}); return false;"><img src="css/layout/copy.png" alt="" width="14" height="14" hspace="3" border="0"></a>
						<a href="dialog/component_delete.php?id=$nID" title="Delete Component" onClick="Modalbox.show(this.href,{title: this.title, width: 450, overlayClose:false}); return false;"><img src="css/layout/action4.gif" alt="" width="14" height="13" hspace="3" border="0"></a>
					</td>
				  </tr>
				  <tr style="background-color:#fff;">
				  	<td colspan="2"><div style="padding:12px;overflow:hidden;" class="handleComp">$nCompCode</div></td>
				  </tr>
				</table>
			</div>
CODE;
	}
	// Create sortable
	if($nTable){ $nDropOnEmpty = "dropOnEmpty: false"; } else { $nDropOnEmpty = "dropOnEmpty: true"; }
	$nSortableCreateARRAY[] = "Sortable.create('pageColumn_$nColumnID',{onUpdate:saveChanges, handleComp:'handleComp', tag:'div',constraint:false, containment: sections, only:'component', $nDropOnEmpty,markDropZone:false});";
	$nSortableARRAY[] = "'pageColumn_$nColumnID'";
	return $nTable;
}
function nGetComponentTitle($nContentID){
	global $DBName,$Link,$nDefaultLang;
	if(!$nContentID){ return; }
	$Query = "SELECT nText FROM nTranslate WHERE nItemID='$nContentID' AND nLang='$nDefaultLang' AND nType='comp' AND nOrderID='1'";
	$Result = mysql_db_query ($DBName,$Query,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nTitle = $Row["nText"];
	}
	return $nTitle;
}
function nGetComponentCloneARRAY($nRecID){
	global $DBName,$Link;
	if(!$nRecID){ return; }
	// Get associated content ID
	$nSQL = "SELECT * FROM xComponentPage WHERE nID=$nRecID";
	$Result = mysql_db_query ($DBName,$nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nContentID = $Row["nContentID"];
		$nCompID = $Row["nComponentID"];
	}
	// Get all component/content clones
	$nCloneARRAY = array();
	$nSQL = "SELECT nPageID FROM xComponentPage WHERE nComponentID='$nCompID' AND nContentID='$nContentID'";
	$Result = mysql_db_query ($DBName,$nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nCloneARRAY[] = $Row["nPageID"];
	}
	return $nCloneARRAY;
}
?>
<? require("../../inc/db_close.php"); ?>
