<?php
/*
 * This file is part of Web Pro Manager.
 * 
 * Web Pro Manager is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Web Pro Manager is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Web Pro Manager.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * @author The Web Pro Miami, Inc. <info@thewebpro.com>
 * @copyright The Web Pro Miami, Inc. <info@thewebpro.com>, http://www.thewebpro.com/
 * @license http://www.gnu.org/licenses/gpl.html GNU GPL
 * @package WebProManager
*/

// Next line to start calc of page load time
$nPLTStart = microtime(); $nPLTStartARRAY = explode(" ", $nPLTStart); $nPLTStart = $nPLTStartARRAY[1] + $nPLTStartARRAY[0];
require("inc/stop_cache.php");
require("inc/secure_page.php");
// connect to mysql
require("../inc/dbconnect.php");
require("../inc/config.php");
require("../inc/tracker.php");
require("inc/whosonline.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title>Control Panel :: <?=$nSiteName;?></title>
<link rel="stylesheet" type="text/css" href="css/meta-admin.css" />
<link rel="stylesheet" type="text/css" href="css/blue-theme.css" />
<!--[if lte IE 6]><link media="screen" rel="stylesheet" type="text/css" href="css/ie.css" /><![endif]-->
<script type="text/javascript" src="js/css.js"></script>
<script type="text/javascript" src="js/behaviour.js"></script>
<script type="text/javascript" src="js/refresh.js"></script>
</head>

<body>
	<!--[if !IE]>start wrapper<![endif]-->
	<div id="wrapper">

		<? require("inc/header.php"); ?>
	
		<!--[if !IE]>start content<![endif]-->
		<div id="content">
			
			<!--[if !IE]>start content bottom<![endif]-->
			<div id="content_bottom">
			
			<div class="inner">
				
				<!--[if !IE]>start info<![endif]-->
				<div id="info">
					
					<!--[if !IE]>start section<![endif]-->
					<div class="section">
						<div class="title_wrapper">
							<h2>Welcome</h2>
						</div>
						
						<!--[if !IE]>start section inner<![endif]-->
						<div class="section_inner">
							<div id="dashboard">
									
									<p>
									You are currently logged in to the <strong><?=$nCoName;?> Content Management System (CMS)</strong>.
									<BR><BR><BR>
									Your user role is <?if($nAdminAccess){ echo "<strong>Admnistrator.</strong>"; } else { echo "<strong>Editor.</strong>"; } ?> 
									<?if($nAdminAccess){ ?>
										You can edit all sections, pages, files and users on the site.
										<BR><BR>
									<? } else { ?>
										You have access to edit the following pages:<BR>
										<?php
										$nUserID = nGetUserIDFromName($ValidUser);
										if($nUserID){ $nPageList = nGetEditablePages($nUserID); }
										if(!$nPageList){ echo "<em class=\"caption\">No access to any pages.</em>"; } else { echo "$nPageList"; }
										?>
										<BR><BR><BR>
										<em>For more detailed information about any of these pages, or to make changes to any pages for which you do not have access, please <strong>contact an Administrator</strong> of the system.</em>
									<? } ?>
									<BR><BR><BR>
									<BR><BR><BR>
									<BR><BR><BR>
									<BR><BR><BR>
									<BR><BR><BR>
									<BR><BR><BR>
							</div>
						</div>
						<!--[if !IE]>end section inner<![endif]-->
						
					</div>
					<!--[if !IE]>end section<![endif]-->
					
				</div>
				<!--[if !IE]>end info<![endif]-->
				
				
<?php
nCleanupTracker(5);
$nAmountActive = nGetAmountActive();
$nAmountLoggedIn = nGetAmountLoggedIn();
?>
				
				<!--[if !IE]>start sidebar<![endif]-->
				<div id="sidebar">
					
					<!--[if !IE]>start sidebar module<![endif]-->
					<div class="sidebar_module">
						<div class="title_wrapper">
							<h3>Statistics</h3>
						</div>
						<div id="statistics">
							<dl>
								<dt>Visitors currently on site</dt>
								<dd><?=$nAmountActive;?></dd>
							</dl>
							<dl>
								<dt>Users logged in to CMS</dt>
								<dd><?=$nAmountLoggedIn;?></dd>
							</dl>
						</div>
					</div>
					<!--[if !IE]>end sidebar module<![endif]-->
					
					
					
					<!--[if !IE]>start sidebar module<![endif]-->
					<div class="sidebar_module">
						<div class="title_wrapper">
							<h3>Quick Links</h3>
						</div>
						<div id="secondary_menu">
							<ul>
								<li><a href="<?=$nFullSitePath;?>" target="_blank">View Website</a> <span class="caption">(opens in new window)</span></li>
								<li><a href="settings_edit.php">Site Settings</a></li>
								<li><a href="sys_settings_edit.php">System Settings</a></li>
							</ul>
						</div>
					</div>
					<!--[if !IE]>end sidebar module<![endif]-->
					
				</div>
				<!--[if !IE]>end sidebar<![endif]-->
				
			</div>
			<!--[if !IE]>end content bottom<![endif]-->
			</div>
			
		</div>
		<!--[if !IE]>end content<![endif]-->
	</div>
	<!--[if !IE]>end wrapper<![endif]-->
	
	<? require("inc/footer.php"); ?>
	
</body>
</html>
<?php
function nGetEditablePages($nEditorID){
	global $DBName,$Link;
	$nSQL = "SELECT nPageID,nNavTitle FROM xEditorPage LEFT JOIN nPage ON nPageID=nPage.nID WHERE nEditorID=$nEditorID ORDER BY nType,nNavTitle";
	$Result = mysql_db_query ($DBName,$nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nPageID = $Row["nPageID"];
		$nPageName = $Row["nNavTitle"];
		$nCode.="<li><a href=\"page_edit.php?id=$nPageID\">$nPageName</a></li>";
	}
	return $nCode;
}
function nGetUserIDFromName($nUserName){
	global $DBName,$Link;
	if(!$nUserName){ return; }
	$Query = "SELECT nID FROM nEditor WHERE nUser='$nUserName' LIMIT 1";
	$Result = mysql_db_query ($DBName,$Query,$Link);
	if($Row = mysql_fetch_array($Result)) {
		$nUserID = $Row[nID];
	}
	return $nUserID;
}
?>
<? require("../inc/db_close.php"); ?>

