<?php
/*
 * This file is part of a larger software package. Please read the License file 
 * in the root of this installation for terms of usage and distribution.
 * 
 * @author The Web Pro Miami, Inc. <info@thewebpro.com>
 * @copyright The Web Pro Miami, Inc. <info@thewebpro.com>, http://www.thewebpro.com/
 * 
 * CORE: manage/dialog/image_edit.php - version 1.02
 *
 * 1.02 - Added image resizing and cropping and other small enhancements
*/

$nSecureMe=1;

// Secure and connect
require("../../inc/dbconnect.php");
require("../inc/secure_page.php");

// bring in other required files
require("../../inc/config.php");
require("../inc/lang.php");

// config
$nRefreshCall = "refreshImages();";

// Get passed-in vars
$nRecID = (isset($_GET['id']) ? $_GET['id'] : NULL);
if(!$nRecID){ $nRecID = (isset($_POST['id']) ? $_POST['id'] : NULL); }

// AJAX Specific vars
$nPassThru = "";
$nDivToUpdate = "editModal";
$nPageInDiv = "dialog/image_edit.php";

$nImagePathOffset = "../../";

// Get info
if($nRecID){
	$nSQL = "SELECT * FROM nImage WHERE nID='$nRecID' LIMIT 1";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nPath = $Row["nPath"];
		$nTitle = $Row["nTitle"];
		$nType = $Row["nType"];
		$nCaption = $Row["nCaption"];
	} else { exit("<div align=\"center\" style=\"padding:20px;\"><em>No record found.</em></div>"); }
	
	if($nPath){
		$nFilename = nGetImageNameFromPath($nPath);
		$nImgTag = "<img src=\"../$nPath\" alt=\"\" border=\"0\" class=\"updateableImg\">";
		if(file_exists($nImagePathOffset.$nPath)){
			$nFilesize = filesize($nImagePathOffset.$nPath);
			if($nFilesize){ $nFilesize = number_format(($nFilesize/1000),0,'.',''); }
			$nImgSizeARRAY = getimagesize($nImagePathOffset.$nPath);
			$nImgW = $nImgSizeARRAY[0]; $nImgH = $nImgSizeARRAY[1]; $nResizeRatio = $nImgW/100;
			$nImgTagFull = "<img src=\"../$nPath\" width=\"$nImgW\" height=\"$nImgH\" alt=\"\" border=\"0\">";
			//if($nImgH<150){ $nImgTag = "<img src=\"../$nPath\" alt=\"\" width=\"$nImgW\" height=\"$nImgH\" border=\"0\">"; }
			//if($nResizeRatio && ($nImgH/$nResizeRatio)>100){ $nImgTag = "<div style=\"overflow:hidden; height:121px; width:150px; vertical-align:middle;\">$nImgTag</div>"; }
		}
	}
	
	$nImagePlacementPageARRAY = nGetImagePlacementPageARRAY($nRecID);
	// xPage has page connection
	$nImagePlacementPageCount = count($nImagePlacementPageARRAY);
	$nImgPlacementText = "";
	if($nImagePlacementPageCount){
		$nImageLinkARRAY = array();
		foreach($nImagePlacementPageARRAY AS $nPageID => $nPageName){
			$nImageLinkARRAY[]="<a href=\"page_edit.php?id=$nPageID\">$nPageName</a>";
		}
		$nImgPlacementText = implode(", ",$nImageLinkARRAY);
	}
	if(!$nImgPlacementText){ $nImgPlacementText = "<em>"._("Not yet linked to any pages.")."</em>"; }
}

// Defaults

?>
<script>
<? if(extension_loaded('gd') && function_exists('gd_info')) { // check for GD library ?>
$(".imageEditDisplay").hover(function() {
	$(".imageEditButtons").show();        
}, function() {
	$(".imageEditButtons").hide();
});
<? } ?>

// Resize tool functions
$("#imageEditResizeButton").click(function() {
 	$("#<? echo $nDivToUpdate ?>").hide();
	$("#imageEditorResize").slideDown('slow');
});
$("#resizeCancel").click(function() {
	$("#imageEditorResize").slideUp('slow');
	$("#<? echo $nDivToUpdate ?>").show();
});
$('#nResizeW').keyup(function() {
	var origW = $('.nImgW').html(),
		origH = $('.nImgH').html(),
		resizeW = $('#nResizeW').val(),
		resizeH = $('#nResizeH').val();
	var origRatio = origW / origH;
	if($('#nResizeConstrain').is(':checked')){ $('#nResizeH').val( Math.round(resizeW/origRatio) ); }
});
$('#nResizeH').keyup(function() {
	var origW = $('.nImgW').html(),
		origH = $('.nImgH').html(),
		resizeW = $('#nResizeW').val(),
		resizeH = $('#nResizeH').val();
	var origRatio = origW / origH;
	if($('#nResizeConstrain').is(':checked')){ $('#nResizeW').val( Math.round(resizeH*origRatio) ); }
});
$("#resizeSave").click(function() {
	if( $('#nResizeW').val() && $('#nResizeH').val() ){
		var resizeError = "";
		var nNewImgPath = "";
		var nPathOffset = "../";
		$.getJSON('process/json/image_effects.php?iid=<? echo $nRecID; ?>&resizeW='+$('#nResizeW').val()+'&resizeH='+$('#nResizeH').val()+'&tmpimg='+$('#nTmpImg').val(), function(data) {
			var items = [];
			$.each(data, function(key, val) {
				switch(key){
					case "nNewImgPath": nNewImgPath = val; $("#nTmpImg").val(nNewImgPath); break;
					case "nNewImgFilesize": $("#nImgFilesize").html(val); break;
					case "nNewImgW": $(".nImgW").html(val); $(".imgWFld").val(val); break;
					case "nNewImgH": $(".nImgH").html(val); $(".imgHFld").val(val); break;
					case "nErrorText": resizeError = val; break;
				}
			});
			if(resizeError){
				alert('There was an error processing the image. '+resizeError);
			} else {
				// Update images
				if(nNewImgPath){
					$(".updateableImg").attr("src", nPathOffset+nNewImgPath);
				}
				// Close resize editor
				$("#imageEditorResize").slideUp('slow');
				$("#<? echo $nDivToUpdate ?>").show();
				$("#nSaveOverOriginalBox").show();
				$("#nLinkedUpBox").hide();
			}
		});
	} else {
		alert("<?php echo _("Please make a selection on your image to crop before saving, or just click 'Cancel' to return."); ?>");
	}

});

// Cropping tool functions
$("#imageEditCropButton").click(function() {
 	$("#<? echo $nDivToUpdate ?>").hide();
	$("#imageEditorCrop").slideDown('slow', function() {
		// Animation complete.
	});
});
// Add JCrop
var jcrop_api;
jCropInit();
$('#coords').on('change','input',function(e){
	var cropX = $('#cropX').val(),
		cropX2 = $('#cropX2').val(),
		cropY = $('#cropY').val(),
		cropY2 = $('#cropY2').val();
	jcrop_api.setSelect([cropX,cropY,cropX2,cropY2]);
});
$("#cropCancel").click(function() {
	$("#imageEditorCrop").slideUp('slow', function() {
		// Animation complete.
	});
	$("#<? echo $nDivToUpdate ?>").show();
});
function jCropInit(){
	$('#imgToCrop').Jcrop({
		onChange:   showCoords,
		onSelect:   showCoords,
		onRelease:  clearCoords,
		boxWidth: 780, boxHeight: 500
	},function(){ jcrop_api = this; });
}
$("#cropSave").click(function() {
	// pull in client info and replace pre-set fields
	if( $('#cropW').val() && $('#cropH').val() ){
		var cropError = "";
		var nNewImgPath = "";
		var nPathOffset = "../";
		$.getJSON('process/json/image_effects.php?iid=<? echo $nRecID; ?>&cropX='+$('#cropX').val()+'&cropY='+$('#cropY').val()+'&cropX2='+$('#cropX2').val()+'&cropY2='+$('#cropY2').val()+'&tmpimg='+$('#nTmpImg').val(), function(data) {
			var items = [];
			$.each(data, function(key, val) {
				switch(key){
					case "nNewImgPath": nNewImgPath = val; break;
					case "nNewImgFilesize": $("#nImgFilesize").html(val); break;
					case "nNewImgW": $(".nImgW").html(val); $(".imgWFld").val(val); break;
					case "nNewImgH": $(".nImgH").html(val); $(".imgHFld").val(val); break;
					case "nErrorText": cropError = val; break;
				}
			});
			if(cropError){
				alert('There was an error processing the image. '+cropError);
			} else {
				// Update images
				if(nNewImgPath){
					$(".updateableImg").attr("src", nPathOffset+nNewImgPath);
					if( $("#nTmpImg").val(nNewImgPath) ){
						// Reset crop editor
						jcrop_api.setImage(nPathOffset+nNewImgPath); 
					}
				}
				// Close crop editor
				$("#imageEditorCrop").slideUp('slow');
				$("#<? echo $nDivToUpdate ?>").show();
				$("#nSaveOverOriginalBox").show();
				$("#nLinkedUpBox").hide();
			}
		});
	} else {
		alert("<?php echo _("Please make a selection on your image to crop before saving, or just click 'Cancel' to return."); ?>");
	}

});
// Simple event handler, called from onChange and onSelect
// event handlers, as per the Jcrop invocation above
function showCoords(c){
	$('#cropX').val( Math.round(c.x) );
	$('#cropY').val( Math.round(c.y) );
	$('#cropX2').val( Math.round(c.x2) );
	$('#cropY2').val( Math.round(c.y2) );
	$('#cropW').val( Math.round(c.w) );
	$('#cropH').val( Math.round(c.h) );
	$('#cropWText').html( Math.round(c.w) );
	$('#cropHText').html( Math.round(c.h) );
};
function clearCoords(){
	$('#coords input').val('');
};
</script>

<div id="imageEditorResize" style="display:none;">
	<div class="imageEditDisplay"><? echo $nImgTag; ?></div>
	<BR><BR>
	<div style="text-align:center;">
		<div id="resizeBox">
			<strong><?php echo _("New image dimensions:"); ?></strong><BR><BR>
			<input type="text" name="nResizeW" id="nResizeW" class="imgWFld small" value="<? echo $nImgW; ?>"> pixels x <input type="text" name="nResizeH" id="nResizeH" class="imgHFld small" value="<? echo $nImgH; ?>"> pixels
			<BR><BR>
			<input type="checkbox" name="nResizeConstrain" id="nResizeConstrain" value="1" checked><?php echo _("Constrain image proportions"); ?>
			<BR><BR><BR>
			<button type="button" class="button blue" id="resizeSave"><?php echo _("Resize and Save Changes"); ?></button> <button type="button" class="button" id="resizeCancel"><?php echo _("Cancel"); ?></button>
		</div>
	</div>
</div>

<div id="imageEditorCrop" style="display:none;">
	<?php echo _("Select a portion of the image to crop."); ?> <?php echo _("When finished, click"); ?> <button type="button" class="button blue" id="cropSave"><?php echo _("Crop and Save Changes"); ?></button> <button type="button" class="button" id="cropCancel"><?php echo _("Cancel"); ?></button>
	<BR><BR>
	<div style="display:inline-block; text-align:center;"><img src="../<? echo $nPath; ?>" border="0" id="imgToCrop" class="updateableImg"></div>
	<BR>
	<form id="coords" class="coords" onsubmit="return false;" style="display:none;">
	  <div class="inline-labels">
	  <label>cropX <input type="text" size="4" id="cropX" name="cropX" /></label>
	  <label>cropY <input type="text" size="4" id="cropY" name="cropY" /></label>
	  <label>cropX2 <input type="text" size="4" id="cropX2" name="cropX2" /></label>
	  <label>cropY2 <input type="text" size="4" id="cropY2" name="cropY2" /></label>
	  <label>cropW <input type="text" size="4" id="cropW" name="cropW" /></label>
	  <label>cropH <input type="text" size="4" id="cropH" name="cropH" /></label>
	  </div><BR>
	</form>
	<?php echo _("Crop dimensions in pixels (W x H)"); ?> = <strong id="cropWText">0</strong> x <strong id="cropHText">0</strong>
</div>

<div id="<?php echo $nDivToUpdate;?>">
<?php
include("../inc/form_class.php");

$nFormName = "FormImageEdit";
$nForm1 = new Form();
//$nForm1->DEBUG = true;
$nForm1->Name = $nFormName;
$nForm1->Action = $_SERVER['PHP_SELF'];
$nForm1->CancelText = "Cancel";
$nForm1->CancelRedirect = "$.colorbox.close()";
$nForm1->CancelRedirectIsJS = true;
if($nRecID){
	$nForm1->SubmitText = "Save Changes";
	//$nForm1->ModifyDBTable = "nImage";
	//$nForm1->ModifyDBField = "nID";
	//$nForm1->ModifyDBID = "$nRecID";
}
$nForm1->DontProcess = "id,nPath,nSaveOverOriginal,nTmpImg";
$nForm1->DBLink = $Link;
$nForm1->nUseADODB = false;
// AJAX settings
$nForm1->SubmitIsJS = true;
$nForm1->SubmitToJS = "return submitForm('$nDivToUpdate','$nPageInDiv$nPassThru','$nFormName');return false;";
// Form styling
$nForm1->CleanMarkup = true;
$nForm1->ButtonTemplate = "<div class=\"clearfix grey-highlight\"><div class=\"input no-label\">[#Buttons#]</div></div>\n";
$nForm1->SubmitClass = "button blue";
$nForm1->CancelClass = "button";
$nForm1->FieldTemplate = "<div class=\"clearfix\" id=\"[#RowID#]\" style=\"[#RowStyle#]\">[#Label#]<div class=\"input\" style=\"[#ItemStyle#]\">[#BeforeField#][#Field#][#AfterField#]<span class=\"info\">[#Caption#]</span></div></div>\n";
$nForm1->GroupTemplate = "<div id=\"[#ID#]\" style=\"[#Style#]\" class=\"[#Class#]\">\n[#Name#][#FieldCode#]\n</div>\n";

// Create groups
$nFormGroup1 = new FormGroup();

// Create fields
$nFormField = new FormField("hidden","id");
$nFormField->Value = $nRecID;
$nFormGroup1->AddField($nFormField);

$nFormField = new FormField("static","","");
$nFormField->Value = "
	<div class=\"imageEditDisplay\">
		<div class=\"imageEditButtons\" style=\"display:none;\">
			<button id=\"imageEditCropButton\" type=\"button\" class=\"button black\">Crop Image</button> 
			<button id=\"imageEditResizeButton\" type=\"button\" class=\"button black\">Resize Image</button> 
			<!-- <button id=\"imageEditApplyFilterButton\" type=\"button\" class=\"button black\">Apply Filter</button> //-->
		</div>
		$nImgTag
	</div>
	<div style=\"padding:10px; background:#eee;\">
		<strong>$nFilename</strong> (<span class=\"nImgW\">{$nImgW}</span>px x <span class=\"nImgH\">{$nImgH}</span>px - <span id=\"nImgFilesize\">{$nFilesize}</span>Kb)<BR><BR>
		<strong>Location:</strong> $nFullSitePath$nPath<BR>
	</div>
	";
$nFormField->RowSize = "Half";
$nFormField->RowStyle = "margin-right:20px;";
$nFormGroup1->AddField($nFormField);

$nFormField = new FormField("hidden","nTmpImg","");
$nFormField->Value = "";
$nFormGroup1->AddField($nFormField);

$nFormField = new FormField("checkbox","nSaveOverOriginal","&nbsp; "._("Overwrite original image?"));
$nFormField->Title = _("Un-check this box to keep your original image and save a new one with your changes.");
$nFormField->Rel = "tooltips";
$nFormField->RowID = "nSaveOverOriginalBox";
$nFormField->RowStyle = "display:none;";
$nFormField->DataARRAY = array(
	"nSaveOverOriginal" => _("")
);
$nFormField->SelectedARRAY["nSaveOverOriginal"] = "selected";
$nFormField->LabelStyle = "width:auto;";
$nFormGroup1->AddField($nFormField);

$nFormField = new FormField("text","nTitle",_("Title:"));
$nFormField->Caption = _("Used in image galleries. Max. 150 characters.");
$nFormField->Rel = "tooltips";
$nFormField->Value = $nTitle;
$nFormField = $nForm1->AddValidation("maxlength",$nFormField,150);
$nFormField->Class = "xlarge";
$nFormField->RowSize = "Full";
$nFormGroup1->AddField($nFormField);

$nFormField = new FormField("textarea","nCaption",_("Full Caption:"));
$nFormField->Caption = _("Used in image galleries. HTML is accepted.");
$nFormField->Rel = "tooltips";
$nFormField->Value = $nCaption;
$nFormField->Class = "xlarge";
$nFormField->RowSize = "Full";
$nFormGroup1->AddField($nFormField);

$nFormField = new FormField("select","nType",_("Image Library:"));
$nFormField->DataARRAY = nGetImageLibraryARRAY();
$nFormField->SelectedARRAY = array("$nType" => "checked");
$nFormField = $nForm1->AddValidation("maxlength",$nFormField,150);
$nFormField = $nForm1->AddValidation("required",$nFormField);
$nFormField->Class = "xlarge";
$nFormField->RowSize = "Full";
$nFormGroup1->AddField($nFormField);

$nFormField = new FormField("static","",_("This image is linked to the following pages:"));
$nFormField->Value = "$nImgPlacementText";
$nFormField->RowStyle = "clear:both;float:none;";
$nFormField->RowSize = "Full";
$nFormField->RowID = "nLinkedUpBox";
$nFormGroup1->AddField($nFormField);

// Finalize and display form
$nForm1->AddGroup($nFormGroup1);
$nFormToDisplay = $nForm1->GetForm();

// AJAX redirect if form submitted w/o error, otherwise display form (again, if necessary)
if($nForm1->HasProcessed){
	// Post-processing
	$nRecID = (isset($_POST['id']) ? $_POST['id'] : NULL);
	$nTmpImg = (isset($_POST['nTmpImg']) ? $_POST['nTmpImg'] : NULL);
	$nSaveOverOriginal = (isset($_POST['nSaveOverOriginal']) ? $_POST['nSaveOverOriginal'] : NULL);
	$nTitle = (isset($_POST['nTitle']) ? $_POST['nTitle'] : NULL);
	$nCaption = (isset($_POST['nCaption']) ? $_POST['nCaption'] : NULL);
	$nType = (isset($_POST['nType']) ? $_POST['nType'] : NULL);
	
	$nTitle = addslashes(stripslashes($nTitle));
	$nCaption = addslashes(stripslashes($nCaption));
	
	if($nRecID){
		if($nSaveOverOriginal){
			// Update record
			$Query = "UPDATE nImage SET nTitle='$nTitle',nCaption='$nCaption',nType='$nType' WHERE nID=$nRecID LIMIT 1";
			mysql_select_db($DBName);
			mysql_query($Query, $Link);
		} else {
			// Save new image to DB
			$Query = "INSERT INTO nImage (nID,nTitle,nCaption,nType,nOrderID) VALUES ('','$nTitle','$nCaption','$nType','1')";
			mysql_select_db($DBName);
			mysql_query($Query, $Link);
			$nRecID = mysql_insert_id();
		}
	}
	
	if($nTmpImg){
		if($nSaveOverOriginal){
			// save temporary image over original
			if(file_exists($nImagePathOffset.$nTmpImg)){
				copy( $nImagePathOffset.$nTmpImg , $nImagePathOffset.$nPath );
			}
		} else {
			// create a new copy
			$nPathARRAY = pathinfo($nPath);
			$nNewImgFile = $nPathARRAY['filename'];
			$nNewImgExt = $nPathARRAY['extension'];
			$nNewImgPath = $nPathARRAY['dirname'];
			// Increase filename by 1, or add number at end if does not exist
			if( is_numeric(substr($nNewImgFile,-1,1)) ){ // if last char is number...
				preg_match("/(.*?)(\d+)$/",$nNewImgFile,$nMatches);
				$nNewImgFile = $nMatches[1].($nMatches[2]+1);
			} else {
				$nNewImgFile.="1";
			}
			$nNewPath = $nNewImgPath."/".$nNewImgFile.".".$nNewImgExt;
			copy( $nImagePathOffset.$nTmpImg , $nImagePathOffset.$nNewPath );
			// Update record
			$Query = "UPDATE nImage SET nPath='$nNewPath' WHERE nID=$nRecID LIMIT 1";
			mysql_select_db($DBName);
			mysql_query($Query, $Link);
		}
	}
	
	// Get image info
	$nSQL = "SELECT * FROM nImage WHERE nID='$nRecID' LIMIT 1";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nPath = $Row["nPath"];
	}
	
	// Delete associated temp image (in case any file changes were made)
	if($nPath){
		$nFilename = nGetImageNameFromPath($nPath);
		$nImgTmpPath = "../../usr/img/tmp/$nFilename";
		if(file_exists($nImgTmpPath)){ unlink($nImgTmpPath); }
	}
	
	echo "<script>$nRefreshCall $.colorbox.close();</script>";
} else {
	echo $nFormToDisplay;
	echo "<script>$.colorbox.resize();</script>";
}
?>
</div>
<?php
function nGetImageNameFromPath($nPath){
	if(!$nPath){ return; }
	$nPathARRAY = explode("/",$nPath);
	$nImgName = $nPathARRAY[(count($nPathARRAY)-1)];
	return $nImgName;
}
function nGetImagePlacementPageARRAY($nImgID){
	global $DBName,$Link;
	
	// Search for image connections throughout the system
	$nImagePlacementConnectionARRAY = array();
	$nImagePlacementConnectionARRAY["nProdInfo"] = array("nProdMainImgID","nProdName","Product"); // key: nTable, value(array): nField, nFieldName, nRecType connection in xPage
	$nImagePlacementConnectionARRAY["nProdInfo "] = array("nProdImgID","nProdName","Product");
	$nImagePlacementConnectionARRAY["nCatInfo"] = array("nCatImgID","nCatName","Category");
	$nImagePlacementConnectionARRAY["nGroupInfo"] = array("nGroupImgID","nGroupName","Tag");
	$nImagePlacementConnectionARRAY["nAngler"] = array("nAnglerImgID","nLastName","Angler");
	$nImagePlacementConnectionARRAY["nTeam"] = array("nTeamImgID","nName","Team");
	$nImagePlacementConnectionARRAY["nTeam "] = array("nBoatImgID","nName","Team");
	$nImagePlacementConnectionARRAY["nSponsor"] = array("nSponsorImgID","nName","Sponsor");
	$nImagePlacementConnectionARRAY["nSpecies"] = array("nSpeciesImgID","nName","Specie");
	
	// First, search for direct page/component connections
	$nResultsARRAY = array();
	$nSQL = "SELECT xComponentPage.nPageID FROM nTranslate JOIN xComponentPage ON nTranslate.nItemID = xComponentPage.nContentID WHERE nTranslate.nImgID='$nImgID'";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nPageID = $Row["nPageID"];
		if($nPageID){ $nPageName = nGetPageName($nPageID); }
		$nResultsARRAY["$nPageID"] = "$nPageName";
	}
	
	// Then, search for other more specific connections
	foreach($nImagePlacementConnectionARRAY AS $nTable => $nFieldInfoARRAY){
		$nField = $nFieldInfoARRAY[0];
		$nFieldName = $nFieldInfoARRAY[1];
		if(isset($nFieldInfoARRAY[2])){ $nRecType = $nFieldInfoARRAY[2]; } else { $nRecType = ""; }
		// Check if table exists
		$nSQL = "SHOW TABLES LIKE '$nTable'";
		mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
		$nTableExists = mysql_num_rows($Result) > 0;
		if($nTableExists){
			$nSQL = "SELECT $nTable.nID,$nTable.$nFieldName AS nPageName FROM $nTable WHERE $nTable.$nField='$nImgID' AND xPage.nRecType='$nRecType'";
			if($nRecType){ $nSQL = "SELECT $nTable.nID,$nTable.$nFieldName AS nPageName,xPage.nPageID FROM $nTable JOIN xPage ON $nTable.nID = xPage.nRecID WHERE $nTable.$nField='$nImgID' AND xPage.nRecType='$nRecType'"; }
			mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
			while($Row = mysql_fetch_array($Result)){
				if($nRecType){ $nPageID = $Row["nPageID"]; } else { $nPageID = 0; }
				$nPageName = $Row["nPageName"];
				$nResultsARRAY["$nPageID"] = "$nPageName";
			}
		}
	}
	
	return $nResultsARRAY;
}
function nGetPageName($nPageID){
	global $DBName,$Link;
	if(!$nPageID){ return; }
	$nSQL = "SELECT nNavTitle FROM nPage WHERE nID=$nPageID LIMIT 1";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nNavTitle = $Row["nNavTitle"];
	}
	return $nNavTitle;
}

function nGetImageLibraryARRAY(){
	global $DBName, $Link;
	$nDataARRAY = array();
	$nDataARRAY[""] = "- None -";
	$Query = "SELECT nID,nName FROM nLibrary WHERE nType='image' ORDER BY nName";
	mysql_select_db($DBName); $Result = mysql_query($Query,$Link);
	while ($Row = mysql_fetch_array($Result)) {
		$nID = $Row["nID"];
		$nName = $Row["nName"];
		$nDataARRAY["$nName"] = "$nName";
	}
	return $nDataARRAY;
}
?>
<?php require("../../inc/db_close.php"); ?>
