<?php
/*
 * This file is part of a larger software package. Please read the License file 
 * in the root of this installation for terms of usage and distribution.
 * 
 * @author The Web Pro Miami, Inc. <info@thewebpro.com>
 * @copyright The Web Pro Miami, Inc. <info@thewebpro.com>, http://www.thewebpro.com/
 * 
 * CORE: manage/dialog/page_add.php - version 1.02
*/

$nSecureMe=1;

// Secure and connect
require("../../inc/dbconnect.php");
require("../inc/secure_page.php");

// bring in other required files
require("../inc/langutil.php");
require("../../inc/config.php");
require("../inc/lang.php");

// config
$nRefreshCall = "refreshParentsPageAdd();";

// pull in all active languages (used to create multiple fields, when needed)
$nActiveLangARRAY = nGetLangActiveARRAY();

// Get passed-in vars
$nRecID = (isset($_GET['id']) ? $_GET['id'] : NULL);
if(!$nRecID){ $nRecID = (isset($_POST['id']) ? $_POST['id'] : NULL); }
$nSectionOverrideID = (isset($_GET['sid']) ? $_GET['sid'] : NULL); // override default selection for new pages

// AJAX Specific vars
$nPassThru = "";
$nDivToUpdate = "editModal";
$nPageInDiv = "dialog/page_add.php";

// Get info
if($nRecID){
	$nSQL = "SELECT * FROM nPage WHERE nID='$nRecID' LIMIT 1";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nID = $Row["nID"];
		$nNavTitle = $Row["nNavTitle"];
		$nTitle = $Row["nTitle"];
		$nBGColor = $Row["nBGColor"];
		$nBaseColor = $Row["nBaseColor"];
		$nBGImgID = $Row["nBGImgID"];
		$nType = $Row["nType"];
		$nSectionID = $Row["nSectionID"];
		$nOrderID = $Row["nOrderID"];
	} else { echo "<div align=\"center\" style=\"padding:20px;\"><em>No record found.</em></div>"; }
} else {
	$nID = ""; $nNavTitle = ""; $nTitle = ""; $nBGColor = ""; $nBaseColor = ""; $nBGImgID = ""; $nType = ""; $nSectionID = $nOrderID = "";
}
$nLocked = "";
if($nLocked){ exit("This record is locked and cannot be edited."); }

// Defaults
if($nSectionOverrideID && !$nBGColor){ $nBGColor = nGetMostUsedBGColorInSection($nSectionOverrideID); }
?>

<div id="<?php echo $nDivToUpdate;?>">
<?php
include("../inc/form_class.php");

$nFormName = "FormPageAdd";
$nForm1 = new Form();
//$nForm1->DEBUG = true;
$nForm1->Name = $nFormName;
$nForm1->Action = $_SERVER['PHP_SELF'];
$nForm1->CancelText = _("Cancel");
$nForm1->CancelRedirect = "$.colorbox.close()";
$nForm1->CancelRedirectIsJS = true;
if($nRecID){
	$nForm1->SubmitText = _("Update");
} else {
	$nForm1->SubmitText = _("Add New Page");
}
$nForm1->DBLink = $Link;
$nForm1->nUseADODB = false;
// AJAX settings
$nForm1->SubmitIsJS = true;
$nForm1->SubmitToJS = "return submitForm('$nDivToUpdate','$nPageInDiv$nPassThru','$nFormName');return false;";
$nForm1->DontProcess = "id,nDocumentList,nTemplateID";
// Form styling
$nForm1->FormClass = "form no-border";
$nForm1->CleanMarkup = true;
$nForm1->SubmitClass = "button blue";
$nForm1->CancelClass = "button";
$nForm1->ButtonTemplate = "<div class=\"clearfix grey-highlight\"><div class=\"input no-label\">[#Buttons#]</div></div>\n";
$nForm1->FieldTemplate = "<div id=\"[#RowID#]\" class=\"clearfix\" style=\"[#RowStyle#]\">[#Label#]<div class=\"input\" style=\"[#ItemStyle#]\">[#BeforeField#][#Field#][#AfterField#]<span class=\"info\">[#Caption#]</span></div></div>\n";
$nForm1->GroupTemplate = "<div id=\"[#ID#]\" style=\"[#Style#]\" class=\"[#Class#]\">\n[#Name#][#FieldCode#]\n</div>\n";

// Create groups
$nFormGroup1 = new FormGroup();
$nFormGroup1b = new FormGroup();
$nFormGroup2 = new FormGroup();
$nFormGroup2->Class = "contentGrp";
$nFormGroup3 = new FormGroup();
$nFormGroup3->Class = "tmplGrp";
$nFormGroup4 = new FormGroup();
$nFormGroup4->Class = "linkGrp";
if($nType=="Link"){ $nFormGroup3->Style = "display:none;"; }
if($nType!="Link"){ $nFormGroup4->Style = "display:none;"; }

// Create fields
if($nRecID){
	$nFormField = new FormField("hidden","id");
	$nFormField->Value = $nRecID;
	$nFormGroup1->AddField($nFormField);
}

// Add language-dependent fields
foreach($nActiveLangARRAY as $nLangCode => $nLangName) {
	if($nLangCode==$nDefaultLang){ $nLangSuffix = ""; } else { $nLangSuffix = "_$nLangCode"; }
	if(count($nActiveLangARRAY)>1){ $nLangText = " ($nLangName)"; } else { $nLangText = ""; }
	
	$nFldName = "nNavTitle$nLangSuffix";
	$nFormField = new FormField("text","$nFldName",_("Page Title")."$nLangText:");
	$nFormField->Caption = _("(for navigation, max. 100 characters)");
	$nFormField->Value = nGetLangContent($nLangCode,$nRecID,"page","nText");
	if($nLangCode==$nDefaultLang){ $nFormField = $nForm1->AddValidation("required",$nFormField); }
	$nFormField = $nForm1->AddValidation("maxlength",$nFormField,100);
	$nFormField->Class = "xlarge";
	$nFormField->RowID = "row_$nLangCode";
	$nFormField->RowStyle = "border-bottom: none;";
	if($nLangCode!=$nDefaultLang){ $nFormField->RowStyle = "display:none; border-bottom: none;"; }
	$nFormGroup1->AddField($nFormField);
}
if(count($nActiveLangARRAY)>1){ $nFormGroup1->AddField(nGetLangTabGroup()); }

$nFormField = new FormField("select","nSectionID","<img src=\"img/folder.png\" alt=\"\" width=\"16\" height=\"16\" border=\"0\" style=\"margin-bottom:-2px;\"> "._("Folder:"));
$nFormField->DataARRAY = nGetSectionARRAY();
if($nRecID){ $nFormField->SelectedARRAY = array("$nSectionID" => "selected"); } else { $nFormField->SelectedARRAY = array("$nSectionOverrideID" => "selected"); }
$nFormField = $nForm1->AddValidation("required",$nFormField);
$nFormField->Class = "xlarge";
$nFormGroup1b->AddField($nFormField);

$nFormField = new FormField("select","nType",_("Page Type:"));
$nFormField->DataARRAY = nGetPageTypeARRAY($nType);
if($nRecID){
	$nFormField->SelectedARRAY = array("$nType" => "selected");
} else {
	$nFormField->SelectedARRAY = array("Content" => "selected"); // default
}
$nFormField->RowSize = "Half";
$nFormField->onBlur = "togglePageFields(this.value);";
$nFormField = $nForm1->AddValidation("required",$nFormField);
$nFormGroup1b->AddField($nFormField);

/*
$nFormField = new FormField("select","nBGImgID","Background Image:");
$nFormField->Caption = "Select and <a href=\"javascript:;\" onClick=\"previewImg();\">preview</a> image, or <a href=\"popup_imglib.php?t=Background\" target=\"imgLib\" onClick=\"PopUp(this.href,this.target,720,480,1);\">manage images in the image library</a>.";
$nFormField->DataARRAY = nGetImgARRAY("Background");
if($nBGImgID){
	$nFormField->SelectedARRAY = array("$nBGImgID" => "selected");
} else {
	$nFormField->SelectedARRAY = array("0" => "selected"); // default
}
$nFormField->RowSize = "Half";
$nFormField->Style = "width:200px;";
$nFormField->RowStyle = "clear:both;float:none;";
$nFormGroup2->AddField($nFormField);
*/

$nFormField = new FormField("radio","nBGColor",_("Icon Color:"));
$nFormField->DataARRAY = array(
	"#007bb6" => "<strong style='background-color:#007bb6;padding:2px;color:#FFF;width:20px;'>&nbsp; &nbsp;</strong>",
	"#bac870" => "<strong style='background-color:#bac870;padding:2px;color:#FFF;width:20px;'>&nbsp; &nbsp;</strong>",
	"#dd1a21" => "<strong style='background-color:#dd1a21;padding:2px;color:#FFF;width:20px;'>&nbsp; &nbsp;</strong>",
	"#bb1b8d" => "<strong style='background-color:#bb1b8d;padding:2px;color:#FFF;width:20px;'>&nbsp; &nbsp;</strong>",
	"#f99f1c" => "<strong style='background-color:#f99f1c;padding:2px;color:#FFF;width:20px;'>&nbsp; &nbsp;</strong>",
	"#009f4f" => "<strong style='background-color:#009f4f;padding:2px;color:#FFF;width:20px;'>&nbsp; &nbsp;</strong>",
	"#d76e2a" => "<strong style='background-color:#d76e2a;padding:2px;color:#FFF;width:20px;'>&nbsp; &nbsp;</strong>",
	"#ff6a14" => "<strong style='background-color:#ff6a14;padding:2px;color:#FFF;width:20px;'>&nbsp; &nbsp;</strong>",
	"#00b1b7" => "<strong style='background-color:#00b1b7;padding:2px;color:#FFF;width:20px;'>&nbsp; &nbsp;</strong>",
	"#bbd821" => "<strong style='background-color:#bbd821;padding:2px;color:#FFF;width:20px;'>&nbsp; &nbsp;</strong>",
	"#000000" => "<strong style='background-color:#000000;padding:2px;color:#FFF;width:20px;'>&nbsp; &nbsp;</strong>");
if($nBGColor){
	$nFormField->SelectedARRAY = array("$nBGColor" => "selected");
} else {
	$nFormField->SelectedARRAY = array("#007bb6" => "selected"); // default
}
$nFormField->LabelStyle = "width:3.5em;";
//$nFormField->Caption = "Choose the page background color.";
$nFormGroup2->AddField($nFormField);

if(!$nRecID){
	$nFormField = new FormField("select","nTemplateID",_("Template:"));
	$nFormField->Caption = _("Choose which template should be used to fill in the default content for this page.");
	$nFormField->DataARRAY = nGetTemplateARRAY();
	$nFormField = $nForm1->AddValidation("required",$nFormField);
	$nFormField->RowSize = "Full";
	$nFormField->Style = "width:400px;";
	$nFormGroup3->AddField($nFormField);
}

$nFormField = new FormField("select","nDocumentList",_("Choose a document to link to:"));
$nFormField->DataARRAY = nGetDocumentARRAY();
if($nRecID){ $nFormField->SelectedARRAY = array("$nTitle" => "selected"); }
$nFormField = $nForm1->AddValidation("required",$nFormField);
$nFormField->RowSize = "Half";
$nFormField->Style = "width:400px;";
$nFormField->onBlur = "autoFillTitle($('#nDocumentList'));";
$nFormGroup4->AddField($nFormField);

$nFormField = new FormField("text","nTitle",_("...or write in your own link:"));
$nFormField->Caption = _("(ex. http://www.google.com/ ...or... /img/pdf/my_doc.pdf)");
$nFormField->Value = $nTitle;
$nFormField->Style = "width:400px;";
$nFormGroup4->AddField($nFormField);

// Finalize and display form
$nForm1->AddGroup($nFormGroup1);
$nForm1->AddGroup($nFormGroup1b);
$nForm1->AddGroup($nFormGroup3);
$nForm1->AddGroup($nFormGroup4);
$nForm1->AddGroup($nFormGroup2);
$nFormToDisplay = $nForm1->GetForm();

// AJAX redirect if form submitted w/o error, otherwise display form (again, if necessary)
if($nForm1->HasProcessed){
	// Post-processing
	if(isset($_POST["id"])){ $nRecID = $_POST["id"]; } else { $nRecID = ""; }
	$nNavTitle = nConvertIntChars($_POST["nNavTitle"]);
	$nPageType = $_POST["nType"];
	$nSectionID = $_POST["nSectionID"];
	$nBGColor = $_POST["nBGColor"];
	$nTitle = $_POST["nTitle"];
	$nTemplateID = $_POST["nTemplateID"];
	if($nRecID){
		// editing existing page
		$Query = "UPDATE nPage SET nNavTitle='$nNavTitle',nType='$nPageType',nSectionID='$nSectionID',nBGColor='$nBGColor',nTitle='$nTitle' WHERE nID=$nRecID LIMIT 1";
		mysql_select_db($DBName);
		mysql_query($Query, $Link);
		
		// log system event
		$nSystemEventDesc = "Page settings edited: [nPageID:$nRecID]";
		$Query = "INSERT INTO nSystemEventLog (nEventTime,nEventDesc,nEditorUser) VALUES ('".date("Y-m-d H:i:s")."','$nSystemEventDesc','$ValidUser')";
		mysql_select_db($DBName); mysql_query($Query, $Link);
	} else {
		// creating new page
		$nLastOrderID = nGetLastOrderIDInSection($nSectionID);
		if($nLastOrderID){ $nOrderID = $nLastOrderID+1; } else { $nOrderID = 1; }
		$Query = "INSERT INTO nPage (nNavTitle,nType,nSectionID,nBGColor,nTitle,nOrderID) VALUES ('$nNavTitle','$nPageType','$nSectionID','$nBGColor','$nTitle','$nOrderID')";
		mysql_select_db($DBName);
		mysql_query($Query, $Link);
		$nRecID = mysql_insert_id(); // gets ID of last created row
		
		// log system event
		$nSystemEventDesc = "New page created: [nPageID:$nRecID]";
		$Query = "INSERT INTO nSystemEventLog (nEventTime,nEventDesc,nEditorUser) VALUES ('".date("Y-m-d H:i:s")."','$nSystemEventDesc','$ValidUser')";
		mysql_select_db($DBName); mysql_query($Query, $Link);
	}
	// Update all additional language fields (default language already saved)
	if($nRecID && count($nActiveLangARRAY)){
		foreach($nActiveLangARRAY as $nLangCode => $nLangName) {
			$nType = "page";
			// if default language is not used, get translation from additional fields
			if($nLangCode!=$nDefaultLang){
				// Name
				$nFieldName="nNavTitle_".$nLangCode;
				$nNavTitle = trim($_POST[$nFieldName]);
				$nNavTitle = nConvertIntChars($nNavTitle);
			} else {
				$nNavTitle = nConvertIntChars($_POST["nNavTitle"]);
			}
			if($nRecID){
				// first remove any current content for this language
				$Query = "DELETE FROM nTranslate WHERE nLang='$nLangCode' AND nItemID='$nRecID' AND nType='$nType'";
				mysql_select_db($DBName);
				mysql_query($Query, $Link);
				//print "$Query<BR><BR>";
			}
			// now save new content
			if($nRecID){
				$Query = "INSERT INTO nTranslate (nLang,nItemID,nType,nText,nTextarea,nLinkID,nImgID,nOrderID) VALUES ('$nLangCode','$nRecID','$nType','$nNavTitle','','','','1')";
				mysql_select_db($DBName);
				mysql_query($Query, $Link);
				//print "$Query<BR><BR>";
			}
		}
	}
	// Finalize color scheme
	switch($_POST["nBGColor"]){
		case "#007bb6": $nBaseColor="#bac870"; $nBackBGColor="#dcf2f6"; break;
		case "#bac870": $nBaseColor="#007bb6"; $nBackBGColor="#ebefd6"; break;
		case "#dd1a21": $nBaseColor="#007bb6"; $nBackBGColor="#ffe683"; break;
		case "#bb1b8d": $nBaseColor="#007bb6"; $nBackBGColor="#ebe0ef"; break;
		case "#f99f1c": $nBaseColor="#007bb6"; $nBackBGColor="#fff8a7"; break;
		case "#009f4f": $nBaseColor="#007bb6"; $nBackBGColor="#d5ebdb"; break;
		case "#d76e2a": $nBaseColor="#007bb6"; $nBackBGColor="#f8e8d0"; break;
		default: $nBaseColor="#bac870"; $nBackBGColor="#dcf2f6"; break;
	}
	if(isset($_POST["id"])){
		// Update color scheme
		$Query = "UPDATE nPage SET nBaseColor='$nBaseColor',nBackBGColor='$nBackBGColor' WHERE nID=$nRecID LIMIT 1";
		mysql_select_db($DBName);
		mysql_query($Query, $Link);
		echo "<script>$nRefreshCall $.colorbox.close();</script>";
	} else {
		if($nRecID){
			// Update color scheme
			$Query = "UPDATE nPage SET nBaseColor='$nBaseColor',nBackBGColor='$nBackBGColor' WHERE nID=$nRecID LIMIT 1";
			mysql_select_db($DBName);
			mysql_query($Query, $Link);
			
			// if new page was created with a template, use it now
			if($nTemplateID){
				
				$nPageToDuplicateID = $nTemplateID;
				
				// Get list of components for the old "page"
				$nPageCompsARRAY = array();
				$nPageCompsARRAY = nGetAllPageComps($nPageToDuplicateID);
				
				// Now copy all of these components to the new page
				$nPageID = $nRecID; // use new page ID we just created to copy these to
				if($nPageCompsARRAY){
					foreach($nPageCompsARRAY AS $nPageCompARRAY){
						$nXID = $nPageCompARRAY["xID"]; // component record to duplicate
						$nComponentID = $nPageCompARRAY["nComponentID"];
						$nColumnID = $nPageCompARRAY["nColumnID"];
						$nContentID = $nPageCompARRAY["nContentID"];
						$nXCompOrderID = $nPageCompARRAY["nOrderID"];
						$nCloneAmt = $nPageCompARRAY["nCloneAmt"];
						if($nCloneAmt>0){ $nDuplicateType = "CLONE"; } else { $nDuplicateType = "COPY"; }
						switch($nDuplicateType){
							case "COPY":
								// Get existing component content data
								$nSQL = "SELECT * FROM nContent WHERE nID='$nContentID' LIMIT 1";
								mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
								if($Row = mysql_fetch_array($Result)){
									$nText = $Row["nText"];
									$nTextarea = $Row["nTextarea"];
									$nImgID = $Row["nImgID"];
									$nLinkID = $Row["nLinkID"];
									$nOrderID = $Row["nOrderID"];
								}
								// Replace user-defined template tags
								$nText = str_replace("[#Title#]","$nNavTitle",$nText);
								$nTextarea = str_replace("[#Title#]","$nNavTitle",$nTextarea);
								// Create new row in nContent for this duplicate component
								$Query = "INSERT INTO nContent (nText,nTextarea,nImgID,nLinkID) VALUES ('$nText','$nTextarea',$nImgID,'$nLinkID')";
								mysql_select_db($DBName);
								mysql_query($Query, $Link);
								$nNewContentID = mysql_insert_id(); // gets ID of last created row
								// Create new component
								$Query = "INSERT INTO xComponentPage (nComponentID,nPageID,nColumnID,nContentID,nOrderID) VALUES ('$nComponentID',$nPageID,$nColumnID,$nNewContentID,$nXCompOrderID)";
								mysql_select_db($DBName);
								mysql_query($Query, $Link);
								
								// Copy to additional language fields (default language already saved)
								if($nContentID && count($nActiveLangARRAY)){
									foreach($nActiveLangARRAY as $nLangCode => $nLangName) {
										$nType = "comp";
										$nContentARRAY = nGetContentARRAY($nContentID,$nLangCode,$nType);
										// if default language is not used, get translation from additional fields
										foreach($nContentARRAY AS $nOrderID => $nContentItemARRAY){
											$nText = addslashes($nContentItemARRAY["nText"]);
											$nTextarea = addslashes($nContentItemARRAY["nTextarea"]);
											$nImgID = $nContentItemARRAY["nImgID"];
											$nLinkID = $nContentItemARRAY["nLinkID"];
											// Replace user-defined template tags
											if($nLangCode!=$nDefaultLang){
												// Name
												$nFieldName="nNavTitle_".$nLangCode;
												$nNavTitle = trim($_POST[$nFieldName]);
												$nNavTitle = nConvertIntChars($nNavTitle);
											} else {
												$nNavTitle = nConvertIntChars($_POST["nNavTitle"]);
											}
											$nText = str_replace("[#Title#]","$nNavTitle",$nText);
											$nTextarea = str_replace("[#Title#]","$nNavTitle",$nTextarea);
											// now save new content
											if($nNewContentID){
												$Query = "INSERT INTO nTranslate (nLang,nItemID,nType,nText,nTextarea,nLinkID,nImgID,nOrderID) VALUES ('$nLangCode','$nNewContentID','$nType','$nText','$nTextarea','$nLinkID','$nImgID','$nOrderID')";
												mysql_select_db($DBName);
												mysql_query($Query, $Link);
											}
										}
									}
								}
								break;
							case "CLONE":
								// Create new component
								$Query = "INSERT INTO xComponentPage (nComponentID,nPageID,nColumnID,nContentID,nOrderID) VALUES ('$nComponentID',$nPageID,$nColumnID,$nContentID,$nXCompOrderID)";
								mysql_select_db($DBName);
								mysql_query($Query, $Link);
								break;
						}
					}
				}
				
			}
		}
		
		if($nPageType=="Link"){
			echo "<script>$nRefreshCall $.colorbox.close();</script>";
		} else {
			echo "<div align=\"center\" id=\"buttonBox\"><BR>";
				echo "<strong>"._("A new page has been succesfully created!")."</strong><BR><BR>";
				echo _("What do you want to do next?")."<BR><BR>";
				echo "<input type=\"button\" class=\"button blue\" name=\"nEdit\" value=\""._("Edit this Page")."\" onClick=\"document.location.href='page_edit.php?id=".$nRecID."'\" class=\"formSubmit\"> ";
				echo "<input type=\"button\" class=\"button\" name=\"nClose\" value=\""._("Close")."\" onClick=\"$.colorbox.close();\" class=\"formCancel\"> ";
			echo "</div>";
			echo "<script>$nRefreshCall $.colorbox.resize();</script>";
		}
	}
} else {
	echo $nFormToDisplay;
	echo "<script>$.colorbox.resize();</script>";
}
?>
</div>
<script>
autoFillTitle = function(fld){
	if(fld.val() && fld.val()!=0){ $('#nTitle').val(fld.val()); }
}
refreshParentsPageAdd = function(){
	try{ refreshMobileComps(); } catch(e){ }
	try{ refreshPageComps(); } catch(e){ }
	try{ refreshPages(); } catch(e){ }
}
togglePageFields = function(fldValue){
	if(fldValue=="Link"){
		//$$('div.contentGrp').each( function(c) { c.hide(); });
		$('.tmplGrp').hide(); $('.linkGrp').show();
		$.colorbox.resize();
	} else {
		$('.linkGrp').hide(); $('.tmplGrp').show();
		//$$('div.contentGrp').each( function(c) { c.show(); });
		$.colorbox.resize();
	}
}
</script>
<?php
function nGetNextPageNum(){
	global $DBName,$Link;
	$nSQL = "SELECT Max(nID) AS nID FROM nPage";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nID = $Row["nID"] + 1;
	}
	return $nID;
}
function nGetDocumentARRAY(){
	global $DBName,$Link;
	$nDataARRAY = array();
	$nDataARRAY[] = "- Please choose -";
	$nSQL = "SELECT nPath FROM nFile ORDER BY nPath ASC";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nPath = $Row["nPath"];
		$nPath = str_replace("usr/docs/","/usr/docs/",$nPath);
		$nPathTxt = str_replace("usr/docs/","",$nPath);
		$nDataARRAY["$nPath"] = "$nPathTxt";
	}
	return $nDataARRAY;
}
function nGetTemplateARRAY(){
	global $DBName,$Link;
	global $nRecID;
	$nDataARRAY = array();
	$nDataARRAY[] = "- Blank page, do not use a template -";
	$nSQL = "SELECT * FROM nPage WHERE nType='Template' ORDER BY nOrderID ASC";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nID = $Row["nID"];
		$nNavTitle = $Row["nNavTitle"];
		$nDataARRAY["$nID"] = "$nNavTitle";
	}
	return $nDataARRAY;
}
function nGetPageTypeARRAY($nCurrPageType){
	global $DBName,$Link;
	global $nRecID;
	$nDataARRAY = array();
	$nSQL = "SELECT * FROM nPageType ORDER BY nAllowMultiple";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nID = $Row["nID"];
		$nName = $Row["nName"];
		$nCode = $Row["nCode"];
		$nAllowMultiple = $Row["nAllowMultiple"];
		if($nAllowMultiple || $nCode==$nCurrPageType){
			$nDataARRAY["$nCode"] = "$nName";
		} else {
			$nPageCount = nGetPageCountForType($nCode);
			if($nPageCount===0){ $nDataARRAY["$nCode"] = "$nName"; }
		}
	}
	$nDataARRAY["Link"] = "Link";
	return $nDataARRAY;
}
function nGetSectionARRAY(){
	global $DBName,$Link;
	global $nRecID;
	$nDataARRAY = array();
	$nSQL = "SELECT * FROM nSection WHERE nName!='Page Templates' ORDER BY nParentID,nName ASC";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nID = $Row["nID"];
		$nName = $Row["nName"];
		$nParentID = $Row["nParentID"];
		if($nParentID){ $nDataARRAY["$nID"] = "- $nName"; } else { $nDataARRAY["$nID"] = "$nName"; }
	}
	return $nDataARRAY;
}
function nGetPageCountForType($nPageType){
	global $DBName,$Link;
	if(!$nPageType){ return; }
	$nSQL = "SELECT nID FROM nPage WHERE nType='$nPageType'";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	$nCount = mysql_num_rows($Result);
	return $nCount;
}
function nGetSearchPageCount(){
	global $DBName,$Link;
	$nSQL = "SELECT nID FROM nPage WHERE nType='Search'";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	$nCount = mysql_num_rows($Result);
	return $nCount;
}
function nGetImgARRAY($nFilter=""){
	global $DBName,$Link;
	$nWhereSQL = "";
	$nDataARRAY = array();
	$nDataARRAY[0] = "- No image -";
	if($nFilter){ $nWhereSQL = "WHERE nType='$nFilter'"; }
	$nSQL = "SELECT nID,nPath FROM nImage $nWhereSQL";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nID = $Row["nID"];
		$nPath = $Row["nPath"];
		$nDataARRAY["$nID"] = "$nPath";
	}
	return $nDataARRAY;
}
function nGetAllPageComps($nPageID){
	global $DBName,$Link;
	if(!$nPageID){ return; }
	$nPageCompsARRAY = array();
	$nSQL = "SELECT xComponentPage.nID AS xID,nComponentID,nColumnID,nContentID,nOrderID FROM xComponentPage LEFT JOIN nComponent ON nComponentID=nComponent.nCompFile WHERE nComponent.nActive=1 AND nPageID=$nPageID ORDER BY nOrderID";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nID = $Row["xID"];
		$nCompID = $Row["nComponentID"];
		$nColumnID = $Row["nColumnID"];
		$nContentID = $Row["nContentID"];
		$nOrderID = $Row["nOrderID"];
		$nCompCloneARRAY = nGetComponentCloneARRAY($nID);
		$nCloneAmt = count($nCompCloneARRAY)-1;
		$nPageCompsARRAY[] = array("xID"=>$nID,"nComponentID"=>$nCompID,"nColumnID"=>$nColumnID,"nContentID"=>$nContentID,"nOrderID"=>$nOrderID,"nCloneAmt"=>$nCloneAmt);
	}
	return $nPageCompsARRAY;
}
function nGetComponentCloneARRAY($nRecID){
	global $DBName,$Link;
	if(!$nRecID){ return; }
	// Get associated content ID
	$nSQL = "SELECT * FROM xComponentPage WHERE nID=$nRecID";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nContentID = $Row["nContentID"];
		$nCompID = $Row["nComponentID"];
	}
	// Get all component/content clones
	$nCloneARRAY = array();
	$nSQL = "SELECT nPageID FROM xComponentPage WHERE nComponentID='$nCompID' AND nContentID='$nContentID'";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nCloneARRAY[] = $Row["nPageID"];
	}
	return $nCloneARRAY;
}
function nGetContentARRAY($nContentID,$nTranslateLang="",$nType="comp"){
	global $DBName,$Link,$nDefaultLang,$nSFLang;
	if(!$nContentID || !is_numeric($nContentID)){ return; }
	if(!$nTranslateLang){ $nTranslateLang = $nSFLang; }
	$nContentARRAY = array();
	$Query = "SELECT * FROM nTranslate WHERE nItemID='$nContentID' AND nLang='$nTranslateLang' AND nType='$nType'";
	mysql_select_db($DBName); $Result = mysql_query($Query,$Link);
	while($Row = mysql_fetch_array($Result)) {
		$nOrderID = $Row["nOrderID"];
		$nContentCompARRAY = array();
		$nContentCompARRAY["nText"] = stripslashes($Row["nText"]);
		$nContentCompARRAY["nTextarea"] = stripslashes($Row["nTextarea"]);
		$nContentCompARRAY["nLinkID"] = stripslashes($Row["nLinkID"]);
		$nContentCompARRAY["nImgID"] = $Row["nImgID"];
		// Add to main array
		$nContentARRAY[$nOrderID] = $nContentCompARRAY;
	}
	return $nContentARRAY;
}
// returns array of active storefront languages in alpha order, default will be first item in array 
function nGetLangActiveARRAY(){
	global $nDefaultLang;
	$nDefaultLangARRAY = array();
	$nLangARRAY = array();
	// Get all files in directory
	$path = "../../lang/";    
	$dir_handle = @opendir($path) or die("Unable to open $path");    
	while ($file = readdir($dir_handle)) {
		if($file == "." || $file == ".." || $file == "index.php" )
			continue;
		$nFileCode = str_replace(".php","",$file);
		if(!is_dir("$path$file/")){
			if(file_exists("$path$file")){ require("$path$file"); }
			if($nFileCode == $nDefaultLang){
				if($nLang){ $nDefaultLangARRAY["$nFileCode"] = $nLang; } // default language
			} else {
				if($nLang){ $nLangARRAY["$nFileCode"] = $nLang; }
			}
		}
	}
	closedir($dir_handle);
	krsort($nLangARRAY);
	foreach($nDefaultLangARRAY as $nLangCode => $nLangName) {
		$nLangARRAY["$nLangCode"] = $nLangName;
	}
	$nLangARRAY = array_reverse($nLangARRAY,true);
	return $nLangARRAY;
}
function nGetLangTabGroup(){
	global $nActiveLangARRAY,$nDefaultLang;
	//$nFormGroup1 = new FormGroup();
	$nHideCodeJS = "";
	$nLangDivARRAY = array();
	$nLangTabARRAY = array();
	foreach($nActiveLangARRAY as $nLangCode => $nLangName) { $nLangDivARRAY[] = "[id=row_$nLangCode]"; $nLangTabARRAY[] = "#tab_$nLangCode"; }
	if($nLangDivARRAY){ $nLangDivList = implode(",",$nLangDivARRAY); }
	if($nLangTabARRAY){ $nLangTabList = implode(",",$nLangTabARRAY); }
	$nHideCodeJS.="$('$nLangDivList').hide(); $('$nLangTabList').removeClass('langTabActive').addClass('langTab');";
	$nLangLinks = "";
	foreach($nActiveLangARRAY as $nLangCode => $nLangName) {
		if($nLangCode==$nDefaultLang){ $nLangSuffix = ""; $nClass="langTabActive"; } else { $nLangSuffix = "_$nLangCode"; $nClass="langTab"; }
		$nLangLinks.="<a href=\"javascript:;\" onClick=\"$nHideCodeJS $('[id=row_$nLangCode]').show(); $('#tab_$nLangCode').removeClass('langTab').addClass('langTabActive');\" id=\"tab_$nLangCode\" class=\"$nClass\">$nLangName</a> ";
	}
	$nFormField = new FormField("static","",_("Language:"));
	$nFormField->Value = $nLangLinks;
	$nFormField->ItemStyle = "font-weight:bold;";
	$nFormField->RowStyle = "border-bottom: 1px solid #D6D6D6;";
	//$nFormGroup1->AddField($nFormField);
	return $nFormField;
}
function nGetLangContent($nLangCode,$nItemID,$nType,$nFieldName,$nOrderID=1){
	global $DBName, $Link;
	if(!$nLangCode || !$nItemID || !$nType || !$nFieldName){ return; }
	$nContent = "";
	$Query = "SELECT $nFieldName AS nContent FROM nTranslate WHERE nLang='$nLangCode' AND nItemID='$nItemID' AND nType='$nType' AND nOrderID='$nOrderID'";
	mysql_select_db($DBName); $Result = mysql_query($Query,$Link);
	while ($Row = mysql_fetch_array($Result)) {
		$nContent = $Row["nContent"];
	}
	return $nContent;
}
function nGetLastOrderIDInSection($nSectionID){
	global $DBName, $Link;
	if(!$nSectionID){ return 0; }
	$nLastOrderID = 0;
	$Query = "SELECT MAX(nOrderID) AS nLastOrderID FROM nPage WHERE nSectionID=$nSectionID";
	mysql_select_db($DBName); $Result = mysql_query($Query,$Link);
	if($Row = mysql_fetch_array($Result)) {
		$nLastOrderID = $Row["nLastOrderID"];
	}
	return $nLastOrderID;
}
function nGetMostUsedBGColorInSection($nSectionID){
	global $DBName, $Link;
	if(!$nSectionID){ return; }
	$nMostUsedBGColor = "";
	$Query = "SELECT nBGColor, COUNT(*) AS nBGColorCount FROM nPage WHERE nSectionID=$nSectionID GROUP BY nBGColor ORDER BY nBGColorCount DESC LIMIT 1";
	mysql_select_db($DBName); $Result = mysql_query($Query,$Link);
	if($Row = mysql_fetch_array($Result)) {
		$nMostUsedBGColor = $Row["nBGColor"];
	}
	return $nMostUsedBGColor;
}
?>
<?php require("../../inc/db_close.php"); ?>
