<?php
/*
 * This file is part of a larger software package. Please read the License file 
 * in the root of this installation for terms of usage and distribution.
 * 
 * @author The Web Pro Miami, Inc. <info@thewebpro.com>
 * @copyright The Web Pro Miami, Inc. <info@thewebpro.com>, http://www.thewebpro.com/
 * 
 * CORE: manage/dialog/section_add.php - version 1.0
*/

require("../inc/stop_cache.php");
$nAdminOnlyPg = 0;
// Secure and connect
require("../../inc/dbconnect.php");
require("../inc/secure_page.php");

// bring in other required files
require("../../inc/config.php");
require("../inc/lang.php");

// config
$nRefreshCall = "refreshPages();";

// Get passed-in vars
$nRecID = (isset($_GET['id']) ? $_GET['id'] : NULL);
if(!$nRecID){ $nRecID = (isset($_POST['id']) ? $_POST['id'] : NULL); }

// AJAX Specific vars
$nPassThru = "";
$nDivToUpdate = "editModal";
$nPageInDiv = "dialog/section_add.php";

// Get info
if($nRecID){
	$nSQL = "SELECT * FROM nSection WHERE nID='$nRecID' LIMIT 1";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nName = $Row["nName"];
		$nParentID = $Row["nParentID"];
		$nLocked = $Row["nLocked"];
	} else { echo "<div align=\"center\" style=\"padding:20px;\"><em>"._("No record found.")."</em></div>"; }
} else {
	$nName = ""; $nParentID = ""; $nLocked = "";
}
$nLocked = "";
if($nLocked){ exit(_("This record is locked and cannot be edited.")); }
?>

<div id="<?php echo $nDivToUpdate;?>">
<?php
include("../inc/form_class.php");

$nFormName = "FormSectionAdd";
$nForm1 = new Form();
//$nForm1->DEBUG = true;
$nForm1->Name = $nFormName;
$nForm1->Action = $_SERVER['PHP_SELF'];
$nForm1->CancelText = _("Cancel");
$nForm1->CancelRedirect = "$.colorbox.close()";
$nForm1->CancelRedirectIsJS = true;
if($nRecID){
	$nForm1->SubmitText = _("Update");
	$nForm1->ModifyDBTable = "nSection";
	$nForm1->ModifyDBField = "nID";
	$nForm1->ModifyDBID = "$nRecID";
} else {
	$nForm1->SubmitText = _("Add Folder");
	$nForm1->AddToDBTable = "nSection";
}
$nForm1->DBLink = $Link;
$nForm1->nUseADODB = false;
// AJAX settings
$nForm1->SubmitIsJS = true;
$nForm1->SubmitToJS = "return submitForm('$nDivToUpdate','$nPageInDiv$nPassThru','$nFormName');return false;";
$nForm1->DontProcess = "id";
// Form styling
$nForm1->FormClass = "form no-border";
$nForm1->CleanMarkup = true;
$nForm1->SubmitClass = "button blue";
$nForm1->CancelClass = "button";
$nForm1->ButtonTemplate = "<div class=\"clearfix grey-highlight\"><div class=\"input no-label\">[#Buttons#]</div></div>\n";
$nForm1->FieldTemplate = "<div id=\"[#RowID#]\" class=\"clearfix\" style=\"[#RowStyle#]\">[#Label#]<div class=\"input\" style=\"[#ItemStyle#]\">[#BeforeField#][#Field#][#AfterField#]<span class=\"info\">[#Caption#]</span></div></div>\n";
$nForm1->GroupTemplate = "<div id=\"[#ID#]\" style=\"[#Style#]\" class=\"[#Class#]\">\n[#Name#][#FieldCode#]\n</div>\n";

// Create groups
$nFormGroup1 = new FormGroup();

// Create fields
if($nRecID){
	$nFormField = new FormField("hidden","id");
	$nFormField->Value = $nRecID;
	$nFormGroup1->AddField($nFormField);
} else {
	$nFormField = new FormField("hidden","nID");
	$nFormField->Value = nGetNextSectionNum();
	$nFormGroup1->AddField($nFormField);
}

$nFormField = new FormField("text","nName",_("<img src=\"img/folder.png\" alt=\"\" width=\"16\" height=\"16\" border=\"0\" style=\"margin-bottom:-2px;\"> Name:"));
$nFormField->Caption = _("(max. 50 characters)");
$nFormField->Value = $nName;
$nFormField = $nForm1->AddValidation("required",$nFormField);
$nFormField = $nForm1->AddValidation("maxlength",$nFormField,50);
$nFormField->Class = "xlarge";
$nFormGroup1->AddField($nFormField);

$nFormField = new FormField("select","nParentID",_("This is a sub-folder of:"));
$nFormField->DataARRAY = nGetSectionARRAY();
if($nRecID){
	$nFormField->SelectedARRAY = array("$nParentID" => "selected");
} else {
	$nFormField->SelectedARRAY = array("0" => "selected"); // default
}
$nFormField->Class = "xlarge";
$nFormGroup1->AddField($nFormField);

// Finalize and display form
$nForm1->AddGroup($nFormGroup1);
$nFormToDisplay = $nForm1->GetForm();

// AJAX redirect if form submitted w/o error, otherwise display form (again, if necessary)
if($nForm1->HasProcessed){
	// Go directly to Edit User screen
	//echo "<script>document.location.href='customer_edit.php?c=".$_POST["CompanyID"]."';</script>";
	//exit();
	if($nRecID){
		// log system event
		$nSystemEventDesc = "Folder settings updated: [nSectionID:$nRecID]";
		$Query = "INSERT INTO nSystemEventLog (nEventTime,nEventDesc,nEditorUser) VALUES ('".date("Y-m-d H:i:s")."','$nSystemEventDesc','$ValidUser')";
		mysql_select_db($DBName); mysql_query($Query, $Link);
		
		echo "<script>$nRefreshCall $.colorbox.close();</script>";
	} else {
		$nRecID = $_POST["nID"];
		
		//echo "<div align=\"center\" id=\"buttonBox\"><BR>";
			//echo "<strong>"._("A new folder has been succesfully created!")."</strong><BR><BR>";
			//echo _("What do you want to do next?")."<BR><BR>";
			//echo "<input type=\"button\" name=\"nEdit\" value=\""._("Edit this Section")."\" onClick=\"document.location.href='section_edit.php?id=".$_POST["nID"]."'\" class=\"formSubmit\"> ";
			//echo "<input type=\"button\" name=\"nClose\" value=\""._("Close")."\" onClick=\"$.colorbox.close();\" class=\"formCancel\"> ";
		//echo "</div>";
		
		// log system event
		$nSystemEventDesc = "New folder created: [nSectionID:$nRecID]";
		$Query = "INSERT INTO nSystemEventLog (nEventTime,nEventDesc,nEditorUser) VALUES ('".date("Y-m-d H:i:s")."','$nSystemEventDesc','$ValidUser')";
		mysql_select_db($DBName); mysql_query($Query, $Link);
		
		echo "<script>$nRefreshCall $.colorbox.close();</script>";
	}
} else {
	echo $nFormToDisplay;
	echo "<script>$.colorbox.resize();</script>";
}
?>
</div>
<?php
function nGetNextSectionNum(){
	global $DBName,$Link;
	$nSQL = "SELECT Max(nID) AS nID FROM nSection";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nID = $Row["nID"] + 1;
	}
	return $nID;
}
function nGetSectionARRAY(){
	global $DBName,$Link;
	global $nRecID;
	$nWhereSQL = "";
	$nDataARRAY = array();
	$nDataARRAY[0] = _("None (This is a main folder)");
	// don't allow this to be a parented by itself OR any of its own children
	if($nRecID){ $nWhereSQL = "WHERE nParentID!=$nRecID AND nID!=$nRecID"; }
	$nSQL = "SELECT * FROM nSection $nWhereSQL ORDER BY nParentID,nName ASC";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nID = $Row["nID"];
		$nName = $Row["nName"];
		$nParentID = $Row["nParentID"];
		if($nID!=$nRecID){
			if($nParentID){ $nDataARRAY["$nID"] = "- $nName"; } else { $nDataARRAY["$nID"] = "$nName"; }
		}
	}
	return $nDataARRAY;
}
?>
<?php require("../../inc/db_close.php"); ?>
