<?php
/*
 * This file is part of a larger software package. Please read the License file 
 * in the root of this installation for terms of usage and distribution.
 * 
 * @author The Web Pro Miami, Inc. <info@thewebpro.com>
 * @copyright The Web Pro Miami, Inc. <info@thewebpro.com>, http://www.thewebpro.com/
 * 
 * CORE: manage/index.php - version 1.0
*/

require("inc/stop_cache.php");
require("inc/install.php");

// connect to mysql
require("../inc/dbconnect.php");
require("../inc/config.php");
require("inc/lang.php");

/* Make sure request is coming in from valid location
$nURI = str_replace("index.php","",$_SERVER["REQUEST_URI"]);
$errorCode = (isset($_GET["error"]) ? $_GET["error"] : NULL);
if(!$errorCode){
	if($nURI && substr($nURI,strlen($nURI)-1)!="/"){ header ("Location: ".$nFullSitePath."manage/"); }
}
*/

// set globals
$nSiteName = str_replace("www.","",$nSiteName);
$nErrorCode = (isset($_GET["error"]) ? $_GET["error"] : NULL);
$nUser = (isset($_GET["nUser"]) ? $_GET["nUser"] : NULL);
if($nUser){ $nUser = base64_decode($nUser); }
$nMsgCode = (isset($_GET["msg"]) ? $_GET["msg"] : NULL);
$nRedirect = (isset($_GET["r"]) ? nSanitizeURL($_GET["r"]) : NULL);

$nSysMsg = $nErrMsg = "";
if($nMsgCode){ $nSysMsg = nGetSysMessage($nMsgCode); }
if($nErrorCode){ $nErrMsg = nGetErrorMessage($nErrorCode); }

// Check for cookie
$nMemUser = (isset($_COOKIE["nMemUser"]) ? base64_decode($_COOKIE["nMemUser"]) : NULL);
$nMemUserToken = (isset($_COOKIE["nMemUserToken"]) ? $_COOKIE["nMemUserToken"] : NULL);

$nTokenVerified = 0;
if($nMemUser && $nMemUserToken && nVerifyUserToken($nMemUserToken,$nMemUser)){ $nTokenVerified = 1; } // authenticate if valid user and token are found

if(!$nUser && $nMemUser){ $nUser = $nMemUser; }
?>

<!doctype html>  
<html lang="en-us">
<head>
	<meta http-equiv="X-UA-Compatible" content="IE=Edge;chrome=1" >
	<meta charset="utf-8">
	<title>Login</title>
	<meta name="Robots" content="None">
	<meta name="viewport" content="width=device-width, initial-scale=1.0"> 
	<link rel="stylesheet" href="assets/styles/columnal/columnal.css" type="text/css" media="screen" />
	<!--[if lt IE 9]>
		<link rel="stylesheet" href="assets/styles/columnal/ie.css" type="text/css" media="screen" />
		<link rel="stylesheet" href="assets/styles/ie8.css" type="text/css" media="screen" />
		<script src="http://ie7-js.googlecode.com/svn/version/2.1(beta4)/IE9.js"></script>
	<![endif]-->
	<link rel="stylesheet" href="assets/scripts/jqueryui/jqueryui.css" type="text/css" media="screen" />
	<link rel="stylesheet" href="assets/styles/style.css" type="text/css" media="screen" />
	<link rel="stylesheet" href="assets/styles/global.css" type="text/css" media="screen" />
	<link rel="stylesheet" href="assets/styles/config.css" type="text/css" media="screen" />
	<script src="assets/scripts/jquery-1.9.1.min.js"></script>
	<script src="assets/scripts/jqueryui/jquery-ui-1.10.3.custom.min.js"></script>
	<script>
	if(top.location!=self.location){ top.location=self.location; } // Frame break
	function nSetFocus(){
		if(document){
			if(document.nLoginForm.nUser.value){ document.nLoginForm.nPwd.focus(); } else { document.nLoginForm.nUser.focus(); }
		}
		<?if($nTokenVerified && !$nErrMsg){ echo "document.nLoginForm.submit();"; }?>
	}
	</script>
</head>
<body id="login" onLoad="nSetFocus();" <?if($nTokenVerified && !$nErrMsg){ echo "style=\"display:none;\""; }?>>
    <div class="container">
        <div class="row">
            
            <p class="center block"><img src="assets/images/logo.png" alt="" border="0"></p>
            <form action="process_login.php" method="post" name="nLoginForm" id="nLoginForm" style="margin:0px;">
            <div class="col_6 pre_3 padding_top_30">
                <div class="widget clearfix margin_bottom_15">
                    <h2><?php echo _("Login"); ?></h2>
                    <div class="widget_inside">
                        <p class="margin_bottom_15">
							<? if($nSysMsg){?><span class="notification information"><?=$nSysMsg?></span><?}?>
							<? if($nErrMsg){?><span class="notification undone"><?=$nErrMsg?></span><?}?>
						</p>
                        <div class="form"><BR>
                            <div class="clearfix">
                                <label><?php echo _("Username"); ?></label>
                                <div class="input">
                                    <input type="text" name="nUser" value="<? echo $nUser; ?>" maxlength="50" class="xlarge"/>
                                </div>
                            </div>
                            <div class="clearfix">
                                <label><?php echo _("Password"); ?></label>
                                <div class="input">
                                    <input type="password" name="nPwd" value="" maxlength="50" class="xlarge"/>
									<BR><BR>
									<a href="pwd_recovery.php"><? echo _("Forgot your password?"); ?></a>
                                </div>
                            </div>
                            <div class="clearfix">
                                <div class="input no-label">
                                    <label for="nRememberMe" class="hand"><input type="checkbox" <?=($nMemUser)?"checked":""?> name="nRememberMe" id="nRememberMe" value="1"><span class="caption"> <?php echo _("Keep me logged in"); ?></span></label>
                                </div>
                            </div>
                            <div class="clearfix grey-highlight">
                                <div class="input no-label ">
                                    <input type="submit" name="nLogin" value="<?php echo _("Login"); ?>" class="button blue">
                                    <a href="<?php echo $nFullSitePath; ?>" class="button"><span><?php echo _("Back to site"); ?></span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            	<p class="center">
					<?php echo _("Copyright"); ?> &copy; <?php echo date("Y"); ?>, <a href="http://www.thewebpro.com/" target="_blank">The Web Pro</a>. All rights reserved.<BR>
					<?php echo _("Custom configured for"); ?> <a href="<?php echo $nFullSitePath; ?>" target="_blank"><?php echo ucwords($nSiteName); ?></a>.
				</p>
			</div>
			</form>
        </div>
    </div>
</body>
</html>
<?php
function nGetErrorMessage($nCode) {
	switch ($nCode) {
		case "1": 
			//$nErrorMessage = "Username was not found in our system.  Please retry your login.<BR><BR><BR>";
			$nErrorMessage = _("Login failed! Please try again."); break;
		case "2": 
			//$nErrorMessage = "The password for that username does not match our records.  Please retry your login.<BR><BR><BR>";
			$nErrorMessage = _("Login failed! Please try again."); break;
		case "3": 
			$nErrorMessage = _("Please fill in both the username and password and retry your login again."); break;
			//$nErrorMessage = "Login failed! Please try again."; break;
		case "4": 
			//$nErrorMessage = "You have tried to access an area that you do not have authorization for.<BR>Please contact your administrator for more information.<BR><BR><BR>";
			$nErrorMessage = _("Login failed! Please try again."); break;
		case "6": 
			//$nErrorMessage = "You have tried to access an area that you do not have authorization for.<BR>Please contact your administrator for more information.<BR><BR><BR>";
			$nErrorMessage = _("Too many login attempts in too short of a time. Please try back again in a few minutes."); break;
		case "7": 
			$nErrorMessage = _("Sorry... you do not have access to this page. Please login with different credentials to access it."); break;
	}
	return $nErrorMessage;
}

function nGetSysMessage($nCode) {
	switch ($nCode) {
		case "1": $nSysMessage = _("You have been successfully logged out."); break;
	}
	return $nSysMessage;
}

function nVerifyUserToken($nMemUserToken,$nMemUser){
	global $DBName,$Link;
	$nUserMatch = FALSE;
	$nNow = date("Y-m-d H:i:s");
	$nTimeLimitToken = 60*60*24*30; // in seconds (token valid for 30 days)
	$nTimeLimitToken = strtotime($nNow)-$nTimeLimitToken;
	$Query = "SELECT nUser,nLoginToken FROM nEditor WHERE UNIX_TIMESTAMP(nTokenDate) >= $nTimeLimitToken";
	mysql_select_db($DBName); $Result = mysql_query($Query,$Link);
	$Num = mysql_num_rows($Result);
	while ($Row = mysql_fetch_array($Result)) {
		if ($Row["nUser"] == $nMemUser) {
			$nUserMatch = TRUE;
			$nLoginToken = $Row["nLoginToken"];
		}
	}
	if($nUserMatch && $nLoginToken==$nMemUserToken){ return true; }
	return false;
}

// cleans URL of strange characters, like exploits and injection attacks
// also checks for the presence of this website in the URL, if does not exist, adds it
function nSanitizeURL($nURL){
	global $nFullSitePath;
	if($nURL==$nFullSitePath){ return $nFullSitePath; }
	$nURL = str_ireplace($nFullSitePath,"",$nURL);
	// clean up trailing and leading slashes
	$nURLARRAY = explode("/",$nURL);
	$nURLARRAY = array_filter($nURLARRAY); // clean out empties
	$nURL = implode("/",$nURLARRAY);
	// clean out all strange chars and hack attempts
	$notAllowed = array("<",">","\"","'","(",")","having","insert","select","update","delete","group by","where");
	$nURL = trim(str_ireplace($notAllowed,"",$nURL));
	$nURL ="$nFullSitePath$nURL";
	$nURL = str_replace(" ","",$nURL);
	return $nURL;
}
?>
<?
// disconnect from mysql
mysql_close($Link);
?>

