<?php
/*
 * This file is part of a larger software package. Please read the License file 
 * in the root of this installation for terms of usage and distribution.
 * 
 * @author The Web Pro Miami, Inc. <info@thewebpro.com>
 * @copyright The Web Pro Miami, Inc. <info@thewebpro.com>, http://www.thewebpro.com/
 * 
 * CORE: manage/list/pages.php - version 1.0b
*/

$nSecureMe=1;

// Secure and connect
require("../../inc/dbconnect.php");
require("../inc/secure_page.php");

// bring in other required files
require("../../inc/config.php");
require("../inc/lang.php");
include("../inc/pageutil.php");
include("../inc/paginator.php");
include("../inc/calendar.php");
require("../inc/imgedit_gd.php");

$nShowPerPg = 999;

// Fix for "lost" pages: in sections that don't exist
nFixLostPages();

// if limited user, get page access to apply limitations
if(!$nAdminAccess){ $nPageIDAccessARRAY = nGetPageIDAccessARRAY($nUnencUser); }
?>
<div id="listContent" style="padding-top:0px;">
<?php
$nDivToUpdate = "ajaxPages";
$nPageInDiv = "list/pages.php";
$nFullPageInDiv = $nPageInDiv;;
// for extrenal refresh requests
print "<script>refreshPages = function(){ loadContent('".$nDivToUpdate."','".$nFullPageInDiv."'); }</script>";
?>


<div id="pageDD">
	<?php echo nGetSectionList();?>
</div>

<style>
.ui-state-highlight{ border:none; background:#fff url('assets/images/icons/icon_placeholder.gif') repeat-x top center; float:left; display:block; width:64px: height:71px; position: relative; margin: 0px 10px 10px 0px; }
</style>
<script type="text/javascript">
// Handle sorting and order saving
$("<?php if($nSortableARRAY){ echo implode(",",$nSortableARRAY); } ?>").sortable({
	distance: 20,
	items: "div.pageIcon", // only icons are sortable
	cancel: "div.pageIconNotSortable", // only icons are sortable
	//containment: "document",
	scroll: true,
	connectWith: ".groupDD", // allow icons to be sorted into different sections
	placeholder: "ui-state-highlight",
	forcePlaceholderSize: true,
	update: function(event, ui) {
		var dataString = "group=" + $(this).attr("id") + "&order=" + $(this).sortable('toArray').toString();
		// save updated order
		var url = "process/page_order.php";
		$.ajax({  
			type: "POST", url: url, data: dataString,  
			error: function(msg,msg2,errorMsg){ alert('error returned in call to '+url+': '+errorMsg); },
			success: function(msg){ }
		});
		$(this).effect("highlight", {}, 1500);
	}
});
function toggleFolder(folderID){
	$('#folder_'+folderID).toggle('slow', function() {
		var isVisible = $('#folder_'+folderID).is(":visible");
		if(isVisible){ $('#folderimg_'+folderID).attr("src","img/folder_open.png"); } else { $('#folderimg_'+folderID).attr("src","img/folder.png"); }
		//alert('complete... is showing? ' + isVisible);
	});
}
</script>


<?php
function nGetSectionList($nShowParentID=0,$nDepth=0){
	global $DBName,$Link;
	global $nAdminAccess,$nSortableARRAY;
	
	// Setup SQL query for displayed listing
	$nSort="nID";  // default sort
	$nSortOrder="ASC";  // default sort order
	$nWhereARRAY[] = "nName!='Page Templates'";
	$nWhereARRAY[] = "nParentID=$nShowParentID";
	
	$nWhereSQL = "";
	if(isset($nWhereARRAY)){ $nWhereSQL = "WHERE ".implode(" AND ",$nWhereARRAY); } else { $nWhereSQL = ""; }
	$nOrderBySQL = "ORDER BY $nSort $nSortOrder";
	$nListingSQL = "SELECT * FROM nSection $nWhereSQL $nOrderBySQL";
	
	$nCurrRec = 0;
	$nTable = "";
	mysql_select_db($DBName); $Result = mysql_query($nListingSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nCurrRec++;
		// get data
		$nID = $Row["nID"];
		$nName = $Row["nName"];
		$nParentID = $Row["nParentID"];
		$nLocked = $Row["nLocked"];
		
		// format data
		$nChildSectionIDARRAY = nGetChildSectionIDARRAY($nID);
		if($nParentID){ $nParentName = nGetSectionName($nParentID); } else { $nParentName = ""; }
		$nPagesCODE = nGetPages($nID);
		if($nAdminAccess){ $nNewPageIconCode = "<div class=\"pageIconNotSortable\"><a href=\"dialog/page_add.php?sid=$nID\" class=\"modal icon\" title=\""._("Add New Page")."\"><div class=\"boxIconCreateNew\"><p>+</p></div></a></div>"; } else { $nNewPageIconCode = ""; }
		if($nPagesCODE){
			$nDropOnEmpty = "dropOnEmpty: false";
			$nFolderIcon = "<a href=\"javascript:;\" onClick=\"toggleFolder('$nID');\"><img src=\"img/folder_open.png\" id=\"folderimg_$nID\" alt=\"\" width=\"16\" height=\"16\" border=\"0\" style=\"margin-bottom:-2px;\"></a>";
		} else {
			$nDropOnEmpty = "dropOnEmpty: true";
			$nFolderIcon = "<a href=\"javascript:;\" onClick=\"toggleFolder('$nID');\"><img src=\"img/folder_open.png\" id=\"folderimg_$nID\" alt=\"\" width=\"16\" height=\"16\" border=\"0\" style=\"margin-bottom:-2px;\"></a>";
		}
		if($nParentName){ $nParentCODE = "<span class=\"caption\">$nFolderIcon <!--$nParentName &gt;//--></span> "; } else { $nParentCODE = "$nFolderIcon "; }
		if(!$nAdminAccess && !$nPagesCODE){ $nHasSectionAccess = 0; } else { $nHasSectionAccess = 1; }
		if($nDepth){ $nStyle = "margin-left:".($nDepth*75)."px;"; } else { $nStyle = ""; }
		
		$nEditText = _("Edit");
		$nDeleteText = _("Delete");
		$nEditItemText = _("Edit Folder");
		$nDeleteItemText = _("Delete Folder");
		
		// display
		if($nHasSectionAccess){
			$nSortableARRAY[] = "#section_$nID"; // add to sortables
			// get children sections
			if($nID && count($nChildSectionIDARRAY)>0){ $nChildSectionList = nGetSectionList($nID,$nDepth+1); } else { $nChildSectionList = ""; }
			// setup editing capability
			$nNameText = "$nParentCODE <a href=\"dialog/section_add.php?id=$nID\" title=\"$nEditItemText\" class=\"modal edit\">$nName</a>";
			if(!$nLocked){ $nDeleteCODE = "<a href=\"dialog/section_delete.php?id=$nID\" id=\"delete_$nID\" title=\"$nDeleteItemText\" class=\"modal delete\" style=\"display:none;\"><img src=\"assets/images/notifications/cross.png\" alt=\"$nDeleteItemText\" width=\"16\" height=\"16\" border=\"0\" style=\"margin-bottom:-2px;\"></a>"; } else { $nDeleteCODE = ""; }
			$nTable.= <<<CODE
			<div id="section_$nID" class="groupDD clearfix" style="$nStyle">
				<h1 class="handle" onMouseOver="$('#delete_$nID').show();" onMouseOut="$('#delete_$nID').hide();">$nNameText $nDeleteCODE</h1>
				<div id="folder_$nID">
					$nPagesCODE $nNewPageIconCode
					<div style="clear:both;"></div>
				</div>
			</div>$nChildSectionList
			
CODE;
		}
	
	}
	if(!$nShowParentID && $nAdminAccess){
		// Add Unclassified section if needed
		$nPagesCODE = nGetPages(0);
		if($nPagesCODE){
			$nSortableARRAY[] = "#section_0"; // add to sortables
			$nTable.= <<<CODE
				<div id="section_0" class="groupDD clearfix">
					<h1 class="handle caption"><em>Unclassified</em></h1>
					$nPagesCODE
				</div>
				<div style="clear:both;"></div>
CODE;
		}
	}
	if(!$nTable){ $nTable = "<tr><td height=\"200\" align=\"center\" class=\"caption\" colspan=\"5\"><em>No data available to display.</em></td></tr>"; }
	return $nTable;
}

function nGetPages($nSectionID){
	global $DBName,$Link,$nAdminAccess,$nPageIDAccessARRAY,$_SERVER,$nLimitPageType;
	if($nSectionID===""){ return ""; }
	$nBrowserType = $_SERVER["HTTP_USER_AGENT"];
	$nIsIE = strpos($nBrowserType," MSIE ");
	$nCurrRec = 0;
	$nTable = "";
	if($nLimitPageType){ $nWhereAddition = "AND nType='$nLimitPageType'"; } else { $nWhereAddition = ""; }
	$nSQL = "SELECT * FROM nPage WHERE nSectionID=$nSectionID $nWhereAddition ORDER BY nOrderID";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nCurrRec++;
		$nID = $Row["nID"];
		$nNavTitle = $Row["nNavTitle"];
		$nTitle = $Row["nTitle"];
		$nBGColor = $Row["nBGColor"];
		$nBaseColor = $Row["nBaseColor"];
		$nBGImgID = $Row["nBGImgID"];
		$nType = $Row["nType"];
		$nLocked = $Row["nLocked"];
		
		if(!$nSectionID){ $nLocked = 0; } // allow deleting of orphaned pages (unclassified category)
		
		if(!$nBGColor){ $nBGColor = "#007bb6"; } // default blue
		switch($nType){
			case "Homepage": $nAddIcon = "<div id=\"edit\"><img src=\"assets/images/icons/icon_home.png\" width=\"26\" height=\"26\" border=\"0\"></div>"; break;
			case "Search": $nAddIcon = "<div id=\"edit\"><img src=\"assets/images/icons/icon_search.png\" width=\"26\" height=\"26\" border=\"0\"></div>"; break;
			case "Link": $nAddIcon = "<div id=\"edit\"><img src=\"assets/images/icons/icon_link.png\" width=\"26\" height=\"26\" border=\"0\"></div>"; break;
			case "Template": $nAddIcon = "<div id=\"edit\"><img src=\"assets/images/icons/icon_template.png\" width=\"26\" height=\"26\" border=\"0\"></div>"; break;
			default: $nAddIcon = ""; break;
		}
		if($nType!="Homepage" && !$nLocked && $nAdminAccess){
			$nAddIcon.="<div id=\"delete\" style=\"display:none;\"><a href=\"dialog/page_delete.php?id=$nID\" title=\"Delete Page\" class=\"modal\"><img src=\"assets/images/icons/icon_delete.png\" alt=\"\" width=\"23\" height=\"23\" border=\"0\" id=\"img_$nID\"></a></div>";
			if($nIsIE!==false){	// if browser is IE...
				$nHoverCODE = "onMouseEnter=\"$('#icon_$nID #delete').show();return false;\" onMouseLeave=\"$('#icon_$nID #delete').hide();return false;\"";
			} else {
				$nHoverCODE = "onMouseOver=\"$('#icon_$nID #delete').show();return false;\" onMouseOut=\"$('#icon_$nID #delete').hide();return false;\"";
			}
		} else {
			$nHoverCODE = "";
		}
		
		$nIcnBGClr = $nBGColor;
		$nIcnTxt = $nNavTitle;
		$nIcnTag = "<div class=\"boxIcon\" style=\"background-color:$nIcnBGClr;\"><p>$nIcnTxt</p></div>";
		
		if(!$nAdminAccess && in_array($nID,$nPageIDAccessARRAY)){ $nHasPageAccess = 1; } else { $nHasPageAccess = 0; }
		if($nAdminAccess){ $nHasPageAccess = 1; }
		if($nHasPageAccess){
			if($nType=="Link"){
				$nIcnTag = "<a href=\"dialog/page_add.php?id=$nID\" title=\"Edit Page Settings\" class=\"modal\">$nIcnTag</a>";
			} else {
				$nIcnTag = "<a href=\"page_edit.php?id=$nID\" title=\"$nIcnTxt\">$nIcnTag</a>";
			}
			$nTable.= <<<CODE
				<div id="icon_$nID" class="pageIcon" $nHoverCODE>$nIcnTag<div id="editStamps" style="width:30px;">$nAddIcon</div></div>
CODE;
		}
	}
	return $nTable;
}

function nGetChildSectionIDARRAY($nSectionID){
	global $DBName,$Link;
	if(!$nSectionID){ return array(); }
	
	$nSectionIDARRAY = array();
	$nSQL = "SELECT nID FROM nSection WHERE nParentID='$nSectionID'";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nSectionIDARRAY[] = $Row["nID"];
	}
	
	return $nSectionIDARRAY;
}

function nGetSectionName($nRecID){
	global $DBName,$Link;
	$nSQL = "SELECT nName,nParentID FROM nSection WHERE nID='$nRecID' LIMIT 1";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nName = $Row["nName"];
		$nParentID = $Row["nParentID"];
	}
	if($nParentID){ $nParentName = nGetSectionName($nParentID)." &gt; "; } else { $nParentName = ""; }
	return "$nParentName$nName";
}

function nFixLostPages(){
	global $DBName,$Link;
	$nSQL = "SELECT nID,nSectionID FROM nPage";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nPageID = $Row["nID"];
		$nSectionID = $Row["nSectionID"];
		if(!nSectionExists($nSectionID)){
			// Set page nSectionID to unclassified section
			$Query = "UPDATE nPage SET nSectionID='0' WHERE nID='$nPageID'";
			mysql_select_db($DBName);
			mysql_query($Query, $Link);
		}
	}
}
function nSectionExists($nSectionID){
	global $DBName,$Link;
	if(!$nSectionID){ return 0; }
	$nSQL = "SELECT nID FROM nSection WHERE nID=$nSectionID";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	$nCount = mysql_num_rows($Result);
	return $nCount;
}
function nGetPageIDAccessARRAY($ValidUser){
	global $DBName,$Link;
	if(!$ValidUser){ return; }
	// Get user ID
	$nSQL = "SELECT nID FROM nEditor WHERE nUser='$ValidUser' LIMIT 1";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nEditorID = $Row["nID"];
	}
	$nDataARRAY = array();
	$nSQL = "SELECT nPageID FROM xEditorPage WHERE nEditorID=$nEditorID";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nPageID = $Row["nPageID"];
		$nDataARRAY[] = $nPageID;
	}
	return $nDataARRAY;
}
?>
<?php require("../../inc/db_close.php"); ?>
