<?
/*
 * This file is part of a larger software package. Please read the License file 
 * in the root of this installation for terms of usage and distribution.
 * 
 * @author The Web Pro Miami, Inc. <info@thewebpro.com>
 * @copyright The Web Pro Miami, Inc. <info@thewebpro.com>, http://www.thewebpro.com/
 * 
 * CORE: manage/process/image_save.php - version 1.01
*/

// Send back "1" on success, error string if not

if(isset($_GET["rid"])){ $nRelID = preg_replace("/[[:^digit:]]/", '',$_GET["rid"]); } else { $nRelID = preg_replace("/[[:^digit:]]/", '',$_POST["rid"]); }
if(isset($_GET["path"])){ $nImgTmpPath = trim(nSanitizeGeneralText($_GET["path"])); } else { $nImgTmpPath = trim(nSanitizeGeneralText($_POST["path"])); }
if(isset($_GET["t"])){ $nType = trim(nSanitizeGeneralText($_GET["t"])); } else { $nType = trim(nSanitizeGeneralText($_POST["t"])); }

// Secure and connect
require("../../inc/dbconnect.php");
require("../inc/secure_page.php");

// Bring in other includes
require("../inc/imgedit_gd.php");

// server-side form error checking
if(!$nImgTmpPath){ exit("The image path can not be empty. Please try again."); }

if($nImgTmpPath){
	// setup paths for image
	$nBaseImgTmpPath = "../../usr/img/tmp/";
	$nImgTmpPath = "$nBaseImgTmpPath$nImgTmpPath";
	$nBaseImgPath = "../../usr/img/";
	$nDBImgPath = "usr/img/";
	$nPostProcess = false;
	
	// create upload folder if does not exist, and if it's writable
	if(!file_exists($nBaseImgTmpPath) || !is_dir($nBaseImgTmpPath)){ mkdir($nBaseImgTmpPath); }
	if(!is_writable($nBaseImgTmpPath)){ exit("Temporary image path, '$nBaseImgTmpPath', is not writable. Image will not be saved. Please update the permissions for this folder to correct this issue."); }
	
	// create upload folder if does not exist, and if it's writable
	if(!file_exists($nBaseImgPath) || !is_dir($nBaseImgPath)){ mkdir($nBaseImgPath); }
	if(!is_writable($nBaseImgPath)){ exit("Image path, '$nBaseImgPath', is not writable. Image will not be saved. Please update the permissions for this folder to correct this issue."); }
	
	switch($nType){
		case "prdMain":
			$nPostProcess = true;
			// setup vars for image processing
			$nMaxWidth = 1000;
			$nMaxHeight = 740;
			$nBaseImgPath = "../../usr/img/prod/original/";
			$nDBImgPath = "usr/img/prod/original/";
			break;
	}
	if($nImgTmpPath){
		$nImgTmpFilename = basename($nImgTmpPath);
	} else {
		exit("Invalid path to image. Image will not be saved.");
	}
	
	// Copy file to public folder and save to db
	$nNewFilename = nSanitizeFilename($nImgTmpFilename);
	$nImgExtension = nImg_GetExtension($nImgTmpFilename);
	if($nImgExtension!="jpg" && $nImgExtension!="gif" && $nImgExtension!="png") { exit("Filetype not supported ($nImgExtension).  Please use a JPG, GIF or PNG image only."); }
	
	// if no errors (no exits)
	if($nImgExtension=="gif"){ $nNewFilename = str_replace(".gif",".jpg",$nNewFilename); $nConvertGIF2JPG=1; } else { $nConvertGIF2JPG=0; }
	// fix filename for duplicates
	$nNum = 1;
	while(file_exists($nBaseImgPath.$nNewFilename)){
		$nNewFilename = str_replace("_$nNum.$nImgExtension",".$nImgExtension",$nNewFilename); // get rid of old num
		$nNum++;
		$nNewFilename = str_replace(".$nImgExtension","_$nNum.$nImgExtension",$nNewFilename); // add new num
	}
	// if temporary file doesn't exist, see if the uploaded file has converted special characters
	if(!file_exists($nImgTmpPath)){ $nImgTmpPath = str_replace(" ","+",$nImgTmpPath); }
	
	if(file_exists($nImgTmpPath)){
		copy($nImgTmpPath,$nBaseImgPath.$nNewFilename);
		unlink($nImgTmpPath);
	} else {
		exit("Temporary file, '$nImgTmpPath', does not exist. Image will not be saved.");
	}
	if($nConvertGIF2JPG){ nImg_ConvertGIF2JPG($nBaseImgPath.$nNewFilename); }
	
	
	// *** Create RelID column, if needed ** Fix for WPM v.1.11 - can be safely removed after next update ***
	$nColExists = false;
	$Query = "SHOW COLUMNS FROM nImage";
	mysql_select_db($DBName); $Result = mysql_query($Query,$Link);
	while($Row = mysql_fetch_assoc($Result)) {
		if($Row["Field"]=="nRelID"){ $nColExists = true; }
	}
	if(!$nColExists){
		$Query = "ALTER TABLE nImage ADD nRelID INT NOT NULL AFTER nPathEnlarge";
		mysql_select_db($DBName);
		mysql_query($Query, $Link);
	}
	
	// Save to db
	$nLastOrderID = nGetLastOrderIDInType($nType);
	if($nLastOrderID){ $nOrderID = $nLastOrderID+1; } else { $nOrderID = 1; }
	$Query = "INSERT INTO nImage (nPath,nRelID,nType,nOrderID) VALUES ('$nDBImgPath$nNewFilename','$nRelID','$nType','$nOrderID')";
	mysql_select_db($DBName);
	mysql_query($Query, $Link);
	
	// Post-processing
	$nImgPath = $nBaseImgPath.$nNewFilename;
	if($nPostProcess && $nPostProcess!="none"){
		// process image (NOTE: needs to be udpated at a future date for additional height and cropping processing)
		if($nImgMagickPath && $nImgPath && $nMaxWidth && is_numeric($nMaxWidth)){
			exec("$nImgMagickPath $nImgPath -resize {$nMaxWidth}x{$nMaxWidth}\> $nImgPath"); // using "\>" makes sure to downscale only
		}
	}
	
	// close and exit
	require("../inc/db_close.php");
}
exit("1");


function nSanitizeGeneralText($nText){
	$notAllowed = array("<",">","1=1","1 =1","1= 1","1 = 1");
	$nText = trim(str_replace($notAllowed,"",$nText));
	$nText = trim(str_replace("\"","&quot;",$nText));
	return $nText;
}
function nSanitizeNumeric($nNumber){
	$nNumber = preg_replace("/[^0-9\.]/", "", $nNumber);
	return $nNumber;
}
function nGetLastOrderIDInType($nType){
	global $DBName, $Link;
	if(!$nType){ return 0; }
	$nLastOrderID = 0;
	$Query = "SELECT MAX(nOrderID) AS nLastOrderID FROM nImage WHERE nType='$nType'";
	mysql_select_db($DBName); $Result = mysql_query($Query,$Link);
	if($Row = mysql_fetch_array($Result)) {
		$nLastOrderID = $Row["nLastOrderID"];
	}
	return $nLastOrderID;
}

require("../inc/db_close.php");
?>