<?php
/*
 * This file is part of a larger software package. Please read the License file 
 * in the root of this installation for terms of usage and distribution.
 * 
 * @author The Web Pro Miami, Inc. <info@thewebpro.com>
 * @copyright The Web Pro Miami, Inc. <info@thewebpro.com>, http://www.thewebpro.com/
 * 
 * CORE: manage/process/json/image_effects.php - version 1.0
*/

$nSecureMe = 1;

$nImageID = preg_replace("/[[:^digit:]]/", '',$_GET["iid"]);
$nTmpImg = nSanitizeGeneralText($_GET["tmpimg"]); // get current temporary image, if any
// Cropping
$nCropX = preg_replace("/[[:^digit:]]/", '',$_GET["cropX"]);
$nCropY = preg_replace("/[[:^digit:]]/", '',$_GET["cropY"]);
$nCropX2 = preg_replace("/[[:^digit:]]/", '',$_GET["cropX2"]);
$nCropY2 = preg_replace("/[[:^digit:]]/", '',$_GET["cropY2"]);
// Resizing
$nResizeW = preg_replace("/[[:^digit:]]/", '',$_GET["resizeW"]);
$nResizeH = preg_replace("/[[:^digit:]]/", '',$_GET["resizeH"]);

if(!$nImageID){ return; }

require("../../inc/stop_cache.php");
require("../../../inc/dbconnect.php");
require("../../inc/secure_page.php");

require("../../inc/imglib/zebra_image.php"); // Cropping utility

$nDataARRAY = array();

$nSQL = "SELECT * FROM nImage WHERE nID='$nImageID' LIMIT 1";
$Result = mysql_db_query ($DBName,$nSQL,$Link);
if($Row = mysql_fetch_array($Result)){
	$nDataARRAY["nOrigImgPath"] = $Row["nPath"];
	$nDataARRAY["nTitle"] = $Row["nTitle"];
	$nDataARRAY["nType"] = $Row["nType"];
	$nDataARRAY["nCaption"] = $Row["nCaption"];
}
$nDataARRAY["nOrigFilename"] = "";
if($nDataARRAY["nOrigImgPath"]){ $nDataARRAY["nOrigFilename"] = nGetFileNameFromPath($nDataARRAY["nOrigImgPath"]); }
if($nTmpImg){ $nDataARRAY["nOrigImgPath"] = $nTmpImg; }

$nPathOffset = "../../../";
$nDataARRAY["nTmpImgPath"] = $nDataARRAY["nError"] = "";
if($nDataARRAY["nOrigImgPath"]){
	$nDateNow = new DateTime();
	$nDataARRAY["nNewFilename"] = $nDateNow->getTimestamp()."_".$nDataARRAY["nOrigFilename"]; // add timestamp to keep new image uncached
	$nDataARRAY["nNewImgPath"] = "usr/img/tmp/".$nDataARRAY["nNewFilename"];
}

// Process resizing
if($nResizeW && $nResizeH && $nDataARRAY["nNewImgPath"]){
	$nDataARRAY["nResizeW"] = $nResizeW;
	$nDataARRAY["nResizeH"] = $nResizeH;
	$nZebraImage = new Zebra_Image();
    $nZebraImage->source_path = $nPathOffset.$nDataARRAY["nOrigImgPath"];
    $nZebraImage->target_path = $nPathOffset.$nDataARRAY["nNewImgPath"];
    $nZebraImage->jpeg_quality = 80;
	$nZebraImage->preserve_aspect_ratio = false;
	if( !$nZebraImage->resize($nResizeW, $nResizeH) ){
		$nDataARRAY["nErrorCode"] = $nZebraImage->error;
		switch($nZebraImage->error){
			case 1: $nDataARRAY["nErrorText"] = 'Your original image file could not be found!'; break;
			case 2: $nDataARRAY["nErrorText"] = 'Your original image file is not readable!'; break;
			case 3: $nDataARRAY["nErrorText"] = 'The resized image could not be written to!'; break;
			case 4: $nDataARRAY["nErrorText"] = 'Image is in an unsupported source file format!'; break;
			case 5: $nDataARRAY["nErrorText"] = 'Your resized image is in an unsupported file format!'; break;
			case 6: $nDataARRAY["nErrorText"] = 'Your GD library version does not support target file format!'; break;
			case 7: $nDataARRAY["nErrorText"] = 'GD library is not installed on your server!'; break;
		}
	} else {
		if( file_exists($nZebraImage->target_path) ){
			$nFilesize = filesize($nZebraImage->target_path);
			if($nFilesize){ $nFilesize = number_format(($nFilesize/1000),0,'.',''); }
			$nImgSizeARRAY = getimagesize($nZebraImage->target_path);
			$nImgW = $nImgSizeARRAY[0]; $nImgH = $nImgSizeARRAY[1];
			// Get new image info
			$nDataARRAY["nNewImgFilesize"] = $nFilesize;
			$nDataARRAY["nNewImgW"] = $nImgW;
			$nDataARRAY["nNewImgH"] = $nImgH;
			if($nTmpImg){ unlink($nPathOffset.$nDataARRAY["nOrigImgPath"]); } // remove old temporary image to save diskspace
		}
	}
}

// Process cropping
if($nCropX2 && $nCropY2 && $nDataARRAY["nNewImgPath"]){
	$nDataARRAY["nCropX2"] = $nCropX2;
	$nDataARRAY["nCropY2"] = $nCropY2;
	$nDataARRAY["nCropX"] = $nCropX;
	$nDataARRAY["nCropY"] = $nCropY;
	$nZebraImage = new Zebra_Image();
    $nZebraImage->source_path = $nPathOffset.$nDataARRAY["nOrigImgPath"];
    $nZebraImage->target_path = $nPathOffset.$nDataARRAY["nNewImgPath"];
    $nZebraImage->jpeg_quality = 80;
	if( !$nZebraImage->crop($nCropX,$nCropY,$nCropX2,$nCropY2) ){
		$nDataARRAY["nErrorCode"] = $nZebraImage->error;
		switch($nZebraImage->error){
			case 1: $nDataARRAY["nErrorText"] = 'Your original image file could not be found!'; break;
			case 2: $nDataARRAY["nErrorText"] = 'Your original image file is not readable!'; break;
			case 3: $nDataARRAY["nErrorText"] = 'The cropped image could not be written to!'; break;
			case 4: $nDataARRAY["nErrorText"] = 'Image is in an unsupported source file format!'; break;
			case 5: $nDataARRAY["nErrorText"] = 'Your cropped image is in an unsupported file format!'; break;
			case 6: $nDataARRAY["nErrorText"] = 'Your GD library version does not support target file format!'; break;
			case 7: $nDataARRAY["nErrorText"] = 'GD library is not installed on your server!'; break;
		}
	} else {
		if( file_exists($nZebraImage->target_path) ){
			$nFilesize = filesize($nZebraImage->target_path);
			if($nFilesize){ $nFilesize = number_format(($nFilesize/1000),0,'.',''); }
			$nImgSizeARRAY = getimagesize($nZebraImage->target_path);
			$nImgW = $nImgSizeARRAY[0]; $nImgH = $nImgSizeARRAY[1];
			// Get new image info
			$nDataARRAY["nNewImgFilesize"] = $nFilesize;
			$nDataARRAY["nNewImgW"] = $nImgW;
			$nDataARRAY["nNewImgH"] = $nImgH;
			if($nTmpImg){ unlink($nPathOffset.$nDataARRAY["nOrigImgPath"]); } // remove old temporary image to save diskspace
		}
	}
}

// Output
echo json_encode($nDataARRAY);


// Utility functions
function nGetFileNameFromPath($nPath){
	$nPathARRAY = explode("/",$nPath);
	// make a duplicate of the last array item
	$nFileName = $nPathARRAY[count($nPathARRAY)-1];
	return $nFileName;
}
function nSanitizeGeneralText($nText){
	$notAllowed = array("<",">","1=1","1 =1","1= 1","1 = 1");
	$nText = trim(str_replace($notAllowed,"",$nText));
	$nText = trim(str_replace("\"","&quot;",$nText));
	return $nText;
}

require("../../inc/db_close.php");
?>
