<?php
/*
 * This file is part of a larger software package. Please read the License file 
 * in the root of this installation for terms of usage and distribution.
 * 
 * @author The Web Pro Miami, Inc. <info@thewebpro.com>
 * @copyright The Web Pro Miami, Inc. <info@thewebpro.com>, http://www.thewebpro.com/
 * 
 * CORE: manage/pwd_recovery.php - version 1.0
*/

require("inc/stop_cache.php");
require("inc/install.php");

// connect to mysql
require("../inc/dbconnect.php");
require("../inc/config.php");
require("inc/lang.php");

$nErrorCode = (isset($_GET['error']) ? $_GET['error'] : NULL);
$nEmail = (isset($_GET['nEmail']) ? $_GET['nEmail'] : NULL);
$nMsgCode = (isset($_GET['msg']) ? $_GET['msg'] : NULL);

$nSysMsg = $nErrMsg = "";
if($nMsgCode){ $nSysMsg = nGetSysMessage($nMsgCode); }
if($nErrorCode){ $nErrMsg = nGetErrorMessage($nErrorCode); }
?>
<!doctype html>  
<html lang="en-us">
<head>
	<meta http-equiv="X-UA-Compatible" content="IE=Edge;chrome=1" >
	<meta charset="utf-8">
	<title>Password Recovery</title>
	<meta name="Robots" content="None">
	<meta name="viewport" content="width=device-width, initial-scale=1.0"> 
	<link rel="stylesheet" href="assets/styles/columnal/columnal.css" type="text/css" media="screen" />
	<!--[if lt IE 9]>
		<link rel="stylesheet" href="assets/styles/columnal/ie.css" type="text/css" media="screen" />
		<link rel="stylesheet" href="assets/styles/ie8.css" type="text/css" media="screen" />
		<script src="http://ie7-js.googlecode.com/svn/version/2.1(beta4)/IE9.js"></script>
	<![endif]-->
	<link rel="stylesheet" href="assets/scripts/jqueryui/jqueryui.css" type="text/css" media="screen" />
	<link rel="stylesheet" href="assets/styles/style.css" type="text/css" media="screen" />
	<link rel="stylesheet" href="assets/styles/global.css" type="text/css" media="screen" />
	<link rel="stylesheet" href="assets/styles/config.css" type="text/css" media="screen" />
	<script src="assets/scripts/jquery-1.9.1.min.js"></script>
	<script src="assets/scripts/jqueryui/jquery-ui-1.10.3.custom.min.js"></script>
	<script>
	if(top.location!=self.location){ top.location=self.location; } // Frame break
	function nSetFocus(){
		if(document){
			document.nLoginForm.nEmail.focus();
		}
	}
	</script>
</head>
<body id="login" onLoad="nSetFocus();">
    <div class="container">
        <div class="row">
            
            <p class="center block"><img src="assets/images/logo.png" alt="" border="0"></p>
            <form action="process_login.php" method="post" name="nLoginForm" id="nLoginForm" style="margin:0px;">
            <div class="col_6 pre_3 padding_top_30">
                <div class="widget clearfix margin_bottom_15">
                    <h2><?php echo _("Password Recovery"); ?></h2>
                    <div class="widget_inside">
                        <p class="margin_bottom_15">
							<? if($nSysMsg){?><span class="notification information"><?=$nSysMsg?></span><?}?>
							<? if($nErrMsg){?><span class="notification undone"><?=$nErrMsg?></span><?}?>
						</p>
                        <div class="form"><BR>
                            <div class="clearfix" style="padding-left:100px;">
								<?php echo _("Please enter the e-mail address associated with your<BR>account and we will send it to you."); ?><BR><BR>
							</div>
							<div class="clearfix">
                                <label><?php echo _("E-mail"); ?></label>
                                <div class="input">
                                    <input type="text" name="nEmail" value="<? echo $nEmail; ?>" maxlength="255" class="xlarge"/>
                                </div>
                            </div><BR>
                            <div class="clearfix grey-highlight">
                                <div class="input no-label ">
                                    <input type="submit" name="nLogin" value="<?php echo _("Get Password"); ?>" class="button blue">
                                    <a href="index.php" class="button"><span><?php echo _("Cancel"); ?></span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            	<p class="center">
					<?php echo _("Copyright"); ?> &copy; <?php echo date("Y"); ?>, <a href="http://www.thewebpro.com/" target="_blank">The Web Pro</a>. All rights reserved.<BR>
					<?php echo _("Custom configured for"); ?> <a href="<?php echo $nFullSitePath; ?>" target="_blank"><?php echo ucwords($nSiteName); ?></a>.
				</p>
			</div>
			<input type="hidden" name="nRedirect" id="nRedirect" value="<?php echo $nRedirect;?>">
			</form>
        </div>
    </div>
</body>
</html>
<?php
function nGetErrorMessage($nCode) {
	switch ($nCode) {
		case "1": 
			//$nErrorMessage = "Username was not found in our system.  Please retry your login.<BR><BR><BR>";
			$nErrorMessage = _("There was a problem emailing the account information. Please try again."); break;
		case "2": 
			//$nErrorMessage = "The password for that username does not match our records.  Please retry your login.<BR><BR><BR>";
			$nErrorMessage = _("Login failed! Please try again."); break;
		case "3": 
			$nErrorMessage = _("Please fill in a valid email address and try again."); break;
			//$nErrorMessage = "Login failed! Please try again."; break;
		case "4": 
			//$nErrorMessage = _("You have tried to access an area that you do not have authorization for.<BR>Please contact your administrator for more information.")."<BR><BR><BR>";
			$nErrorMessage = _("Login failed! Please try again."); break;
		case "6": 
			//$nErrorMessage = _("You have tried to access an area that you do not have authorization for.<BR>Please contact your administrator for more information.")."<BR><BR><BR>";
			$nErrorMessage = _("Too many login attempts in too short of a time. Please try back again in a few minutes."); break;
		case "7": 
			$nErrorMessage = _("Sorry... you do not have access to this page. Please login with different credentials to access it."); break;
	}
	return $nErrorMessage;
}

function nGetSysMessage($nCode) {
	switch ($nCode) {
		case "1": 
			$nSysMessage = _("If an account exists for the email you entered, you will receive a password there soon. Once you recieve it, you can login")." <a href=\"/manage/\">"._("here")."</a>."; break;
	}
	return $nSysMessage;
}

function nVerifyUserToken($nMemUserToken,$nMemUser){
	global $DBName,$Link;
	$nNow = date("Y-m-d H:i:s");
	$nTimeLimitToken = 60*60*24*30; // in seconds (token valid for 30 days)
	$nTimeLimitToken = strtotime($nNow)-$nTimeLimitToken;
	$Query = "SELECT nEmail,nLoginToken FROM nEditor WHERE UNIX_TIMESTAMP(nTokenDate) >= $nTimeLimitToken";
	mysql_select_db($DBName); $Result = mysql_query($Query,$Link);
	$Num = mysql_num_rows($Result);
	while ($Row = mysql_fetch_array($Result)) {
		if ($Row["nEmail"] == $nMemUser) {
			$nEmailMatch = TRUE;
			$nLoginToken = $Row["nLoginToken"];
		}
	}
	if($nEmailMatch && $nLoginToken==$nMemUserToken){ return true; }
	return false;
}

// cleans URL of strange characters, like exploits and injection attacks
// also checks for the presence of this website in the URL, if does not exist, adds it
function nSanitizeURL($nURL){
	global $nFullSitePath;
	if($nURL==$nFullSitePath){ return $nFullSitePath; }
	$nURL = str_ireplace($nFullSitePath,"",$nURL);
	// clean up trailing and leading slashes
	$nURLARRAY = explode("/",$nURL);
	$nURLARRAY = array_filter($nURLARRAY); // clean out empties
	$nURL = implode("/",$nURLARRAY);
	// clean out all strange chars and hack attempts
	$notAllowed = array("<",">","\"","'","(",")","having","insert","select","update","delete","group by","where");
	$nURL = trim(str_ireplace($notAllowed,"",$nURL));
	$nURL ="$nFullSitePath$nURL";
	$nURL = str_replace(" ","",$nURL);
	return $nURL;
}
?>
<?php
require("../inc/db_close.php");
?>

