<?php
/*
 * This file is part of Web Pro Manager.
 * 
 * Web Pro Manager is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Web Pro Manager is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Web Pro Manager.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * @author The Web Pro Miami, Inc. <info@thewebpro.com>
 * @copyright The Web Pro Miami, Inc. <info@thewebpro.com>, http://www.thewebpro.com/
 * @license http://www.gnu.org/licenses/gpl.html GNU GPL
 * @package WebProManager
*/

// Next line to start calc of page load time
$nPLTStart = microtime(); $nPLTStartARRAY = explode(" ", $nPLTStart); $nPLTStart = $nPLTStartARRAY[1] + $nPLTStartARRAY[0];
require("inc/stop_cache.php");
$nAdminOnlyPg = 0;
require("inc/secure_page.php");
// connect to mysql
require("../inc/dbconnect.php");
require("../inc/config.php");
require("inc/lang.php");
require("../inc/tracker.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title>WPM :: <?php echo $nSiteName;?></title>
<link rel="stylesheet" type="text/css" href="css/meta-admin.css" />
<link rel="stylesheet" type="text/css" href="css/blue-theme.css" />
<!--[if lte IE 6]><link media="screen" rel="stylesheet" type="text/css" href="css/ie.css" /><![endif]-->
<link href="css/colorbox.css" rel="stylesheet" type="text/css">
<link href="css/form.css" rel="stylesheet" type="text/css">
<link href="css/drag_drop.css" rel="stylesheet" type="text/css">
<script type="text/javascript" src="js/css.js"></script>
<script type="text/javascript" src="js/behaviour.js"></script>
<script type="text/javascript" src="js/refresh.js"></script>
<script src="js/utility.js" type="text/javascript"></script>
<script src="js/jquery-1.9.1.min.js" type="text/javascript"></script>
<script src="js/jquery.colorbox-min.js" type="text/javascript"></script>
<script src="js/jquery_processor.js" type="text/javascript"></script>
<script>
$(function() {
	// load page content modules
	loadContent('ajaxSections','list/sections.php');
});
</script>
</head>

<body onLoad="MM_preloadImages('img/load.gif');">
	<!--[if !IE]>start wrapper<![endif]-->
	<div id="wrapper">

		<?php require("inc/header.php"); ?>
	
		<!--[if !IE]>start content<![endif]-->
		<div id="content">
			
			<!--[if !IE]>start content bottom<![endif]-->
			<div id="content_bottom">
			
				<div class="inner">
					
					<!--[if !IE]>start info<![endif]-->
					<div id="info">
						
						<!--[if !IE]>start section<![endif]-->
						<div class="section">
						<div class="title_wrapper">
							<h2><?php echo _("Sections"); ?></h2>
							<?php if($nAdminAccess){ ?>
							<div id="product_list_menu">
								<a href="dialog/section_add.php" title="<?php echo _("Add New Section"); ?>" class="modal update"><span><span><em><?php echo _("Add New"); ?></em><strong></strong></span></span></a>
							</div>
							<?php } ?>
						</div>
						
						<div id="ajaxSections"></div><BR>
						
					</div>
					<!--[if !IE]>end info<![endif]-->
					<BR><BR><BR><BR>

				</div>
				
				<!--[if !IE]>start sidebar<![endif]-->
				<div id="sidebar" style="padding-top:11px;">
					
					
					<!--[if !IE]>start sidebar module<![endif]-->
					<div class="sidebar_module">
						<div class="title_wrapper">
							<h3><?php echo _("Sections"); ?></h3>
						</div>
						<div id="secondary_menu">
							<ul>
								<li style="padding:20px 0px;"><?php echo _("<strong>Sections</strong> organize your <em>Pages</em> on the site into manageable groups. These <em>Section</em> groups make up the navigation your website's visitors see."); ?><BR><BR>
								<?php echo _("Each <em>Section</em> can hold any number of <em>Pages</em> and each <em>Section</em> can have any number of <em>sub-Sections</em>."); ?><BR><BR>
								<?php echo _("By default, there are 3 <em>Sections</em>, each corresponding to a main navigation group in your template: <strong>Header</strong>, <strong>Main</strong>, and <strong>Footer</strong>.  They can not be removed."); ?><BR><BR>
							</ul>
						</div>
					</div>
					<!--[if !IE]>end sidebar module<![endif]-->
					
				</div>
				<!--[if !IE]>end sidebar<![endif]-->
				
			</div>
			<!--[if !IE]>end content bottom<![endif]-->
			
		</div>
		<!--[if !IE]>end content<![endif]-->
	</div>
	<!--[if !IE]>end wrapper<![endif]-->
	
	<?php require("inc/footer.php"); ?>
	
<div id="status" style="display:none;"><table><tr><td class="padRight"><img src="img/load.gif" alt="" width="16" height="16" border="0"></td><td><div align="center"><?php echo _("Loading...<BR>Please wait"); ?><BR></div></td></tr></table></div>
	
</body>
</html>
<?php require("../inc/db_close.php"); ?>

