<?
/*
 * This file is part of a larger software package. Please read the License file 
 * in the root of this installation for terms of usage and distribution.
 * 
 * @author The Web Pro Miami, Inc. <info@thewebpro.com>
 * @copyright The Web Pro Miami, Inc. <info@thewebpro.com>, http://www.thewebpro.com/
 * 
 * CORE: manage/tables/image_libraries.php - version 1.0
*/

$nSecureMe = 1;

// Secure and connect
require("../../inc/dbconnect.php");
require("../inc/secure_page.php");

// bring in other required files
require("../../inc/config.php");
require("../inc/lang.php");
require("../inc/plugins.php");
require("../inc/pluginutil.php");
require("../inc/pageutil.php");
require("../inc/calendar.php");

// Get plugin inclusion points for list, and insert them in header
$nPluginListInclARRAY = nGetListPluginInclusions("Categories");

// Setup header
$nColumnARRAY = array();
//$nColumnARRAY["#Checkbox#"] = array("","","","vertical-align:middle;","{ \"sWidth\":\"31\", \"bSortable\":false }");
$nColumnARRAY[ _("Name") ] = array("","","","","");
$nColumnARRAY[ _("Images") ] = array("","","","text-align:center;","{ \"sWidth\":\"100\" }");
$nColumnARRAY[ _("Actions") ] = array("","","","","{ \"sWidth\":\"100\",\"bSortable\":false }");

// Insert plugin inclusion points for list in header
$nColumnARRAY = nInsertPluginHdrIncl($nPluginListInclARRAY,$nColumnARRAY);
$nHeaderDataTableJS = nBuildHeaderDataTableJS($nColumnARRAY);
?>
<script>
	$(function() {
	    // Initialize tables (if more than one per page, give it a second class for customization)
	    $('.dataTable').dataTable({
	        "sPaginationType": "full_numbers",
	        "bJQueryUI": true,
			"bStateSave": true,
			"aaSorting": [[ 0, "asc" ]],
			"aoColumns": [
				<?=$nHeaderDataTableJS;?>
			],
			"iDisplayLength": 50,
			"aLengthMenu": [[20, 50, 100, 200, -1], [20, 50, 100, 200, "All"]],
			"fnDrawCallback":function(){
				// Hide toolbar if showing less records than page-able
				if(this.fnSettings().fnRecordsTotal() <= this.fnSettings()._iDisplayLength){
					$('.dataTables_wrapper div.fg-toolbar').hide();
					$('.dataTables_wrapper').addClass("topBorder bottomBorder");
				} else {
					$('.dataTables_wrapper div.fg-toolbar').show();
				}
			}
	    });//.rowGrouping({bExpandableGrouping: true});
	});
</script>

<form action="javascript:;" method="post" name="nListForm" id="nListForm" style="margin:0px;">
	<?=nGetImageLibraries()?>
</form>

<?
function nGetImageLibraries(){
	global $DBName,$Link,$nParam,$nPluginListInclARRAY,$nColumnARRAY;
	
	$Query = "SELECT * FROM nLibrary ORDER BY nName";
	mysql_select_db($DBName); $Result = mysql_query($Query,$Link); $nNumRec = mysql_num_rows($Result);
	
	$nTable = "";
	$nCurrentRecord = 1;
	
	if($nNumRec){
		// insert header and main listing table
		$nHeaderCode = nBuildHeaderHTML($nColumnARRAY);
		$nTable.="<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"datatable\">";
		$nTable.="<thead><tr class=\"listHdr\">$nHeaderCode</tr></thead>";
		
		while($Row = mysql_fetch_array($Result)){
			// Get data
			$nID = $Row["nID"];
			$nNameRaw = $nName = stripslashes($Row["nName"]);
			
			// Format data
			$nName = str_replace("\"","&quot;",$nName);
			if(!$nName){ $nName = "<em>unnamed</em>"; }
			$nImageCount = nGetImageInLibraryCount($nID);
			$nImageCount = "<a href=\"library_images.php?t=$nName\">$nImageCount</a>";
			$nDeleteLink = "<a href=\"javascript:;\" onClick=\"openDeleteDialog('imglib',$nID,'"._("Delete Image Library")."');\" style=\"color:#777;\" title=\""._("Delete Image Library").": $nName\">"._("Delete")."</a>";
			$nEditLinks = "$nDeleteLink";
			
			// Setup row (data, width, align, class, style)
			$nColumnARRAY = array();
			//$nColumnARRAY["#Checkbox#"] = array("<input type=\"checkbox\" name=\"item_$nCurrentRecord\" value=\"$nID\" onClick=\"updateItemText();\">","","","","");
			$nColumnARRAY["Name"] = array("<a href=\"dialog/image_library_add.php?id=$nID\" title=\"Edit Image Library: ".addslashes($nNameRaw)."\" class=\"modal edit\">$nName</a>","","","","");
			$nColumnARRAY["Images"] = array("$nImageCount","","","","text-align:center;");
			$nColumnARRAY[ _("Actions") ] = array("$nEditLinks","","","","");
			
			// Get plugin inclusion points for list, and insert them in row
			$nColumnARRAY = nInsertPluginRowIncl($nPluginListInclARRAY,$nColumnARRAY,$nID);
			$nRowCode = nBuildRowHTML($nColumnARRAY);
			
			// Insert row
			$nTable.="<tr id=\"row$nID\">$nRowCode</tr>";
			
			$nCurrentRecord++;
		}
		// Insert footer
		// $nTable.= "</table>".nGetActionFooter()."<BR><BR>";
	} else {
		$nTable.= "<div style=\"text-align:center; padding:50px 0;\"><i>There are currently no Image Libraries to display.</i></div>";
	}
	return $nTable;
}
function nGetActionFooter(){
	$nFooter = "<div style=\"padding:8px;\">\n";
	$nFooter.= "	<strong>With <strong id=\"itemAmount\">0</strong> items selected:</strong> \n";
	$nFooter.= "	<input type=\"button\" name=\"nRemove\" id=\"nRemove\" value=\" Remove \" onClick=\"editList('cat','remove');\" disabled> \n";
	$nFooter.= "	<input type=\"button\" name=\"nEdit\" id=\"nEdit\" value=\" Edit \" onClick=\"editList('cat','edit');\" disabled>\n";
	$nFooter.= "</div>\n";
	return $nFooter;
}
function nGetImageInLibraryCount($nLibraryID){
	global $DBName,$Link;
	if(!$nLibraryID){ return; }
	$nSQL = "SELECT nName FROM nImage JOIN nLibrary ON nLibrary.nName=nImage.nType WHERE nLibrary.nID='$nLibraryID'";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	$nTotalResults = mysql_num_rows($Result);
	return $nTotalResults;
}
?>
<?
// disconnect from mysql
mysql_close($Link);
?>