<?php
/*
 * This file is part of Web Pro Manager.
 * 
 * Web Pro Manager is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Web Pro Manager is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Web Pro Manager.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * @author The Web Pro Miami, Inc. <info@thewebpro.com>
 * @copyright The Web Pro Miami, Inc. <info@thewebpro.com>, http://www.thewebpro.com/
 * @license http://www.gnu.org/licenses/gpl.html GNU GPL
 * @package WebProManager
*/

// Next line to start calc of page load time
$nPLTStart = microtime(); $nPLTStartARRAY = explode(" ", $nPLTStart); $nPLTStart = $nPLTStartARRAY[1] + $nPLTStartARRAY[0];
require("inc/stop_cache.php");
$nAdminOnlyPg = 0;
require("inc/secure_page.php");
// connect to mysql
require("../inc/dbconnect.php");
require("../inc/config.php");
require("inc/lang.php");

// Get passed-in vars
$nRecID = (isset($_GET['id']) ? $_GET['id'] : NULL);
if(!$nRecID){ print "GET:"; print_r($_GET); print "POST:"; print_r($_POST); exit(_("Empty record ID.  Please ensure the link you accessed that brought you to this page is correct.")); }

// Additional security check if this account is a limited user (give only self access)
$nMyUserID = nGetUserIDFromName($nUnencUser);
if(!$nAdminAccess && $nRecID!=$nMyUserID){ header ("Location: index.php?msg=4"); exit; }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title>WPM :: <?php echo $nSiteName;?></title>
<link rel="stylesheet" type="text/css" href="css/meta-admin.css" />
<link rel="stylesheet" type="text/css" href="css/blue-theme.css" />
<!--[if lte IE 6]><link media="screen" rel="stylesheet" type="text/css" href="css/ie.css" /><![endif]-->
<link href="css/colorbox.css" rel="stylesheet" type="text/css">
<link href="css/form.css" rel="stylesheet" type="text/css">
<link href="css/drag_drop.css" rel="stylesheet" type="text/css">
<script type="text/javascript" src="js/css.js"></script>
<script type="text/javascript" src="js/behaviour.js"></script>
<script type="text/javascript" src="js/refresh.js"></script>
<script src="js/utility.js" type="text/javascript"></script>
<script src="js/jquery-1.9.1.min.js" type="text/javascript"></script>
<script src="js/jquery.colorbox-min.js" type="text/javascript"></script>
<script src="js/jquery_processor.js" type="text/javascript"></script>
<script>
$(function() {
	// load page content modules
	loadContent('ajaxUserEdit','edit/user.php?id=<?php echo $nRecID;?>');
	loadContent('ajaxUserPageEdit','edit/userpage.php?id=<?php echo $nRecID;?>');
});
</script>
</head>

<body onLoad="MM_preloadImages('img/load.gif');">

<div id="wrapper">
	
	<?php require("inc/header.php"); ?>

	<div id="content">
		<div id="content_bottom">
			<div class="inner">
				<div id="info">
					<div class="section">
					
						<div class="title_wrapper"><h2><?php if($nAdminAccess){ echo _("Edit User"); } else { echo _("My Account"); } ?></h2></div>
						<div id="ajaxUserEdit"></div><BR>
				
					</div>
					<BR><BR><BR><BR>
				</div>
				<div id="sidebar" style="padding-top:0px;">
					<div class="sidebar_module">
						
						<div class="title_wrapper"><h3>&nbsp;</h3></div>
						<div id="secondary_menu">
							
							<div id="ajaxUserPageEdit"></div><BR>
							
						</div>
						
					</div>
				</div>
			</div>
		</div>
	</div>
	
</div>
	
	<?php require("inc/footer.php"); ?>
	
<div id="status" style="display:none;"><table><tr><td class="padRight"><img src="img/load.gif" alt="" width="16" height="16" border="0"></td><td><div align="center"><?php echo _("Loading...<BR>Please wait"); ?><BR></div></td></tr></table></div>
	
</body>
</html>
<?php
function nGetUserIDFromName($nUserName){
	global $DBName,$Link;
	if(!$nUserName){ return; }
	$nUserID = "";
	$Query = "SELECT nID FROM nEditor WHERE nUser='$nUserName' LIMIT 1";
	mysql_select_db($DBName); $Result = mysql_query($Query,$Link);
	if($Row = mysql_fetch_array($Result)) {
		$nUserID = $Row["nID"];
	}
	return $nUserID;
}
?>
<?php require("../inc/db_close.php"); ?>

