<?php
/*
 * This file is part of a larger software package. Please read the License file 
 * in the root of this installation for terms of usage and distribution.
 * 
 * @author The Web Pro Miami, Inc. <info@thewebpro.com>
 * @copyright The Web Pro Miami, Inc. <info@thewebpro.com>, http://www.thewebpro.com/
 * 
 * CORE: manage/library_images.php - version 1.0f
 * 1.0e - now uses urlencode before passing library names, added min-height to image display to help with dropdown cutoff
 * 1.0f - allowed 'Manage Image Libraries' button to be accessed by non-administrators
*/

$nSecureMe = 1;

// Secure and connect
require("../inc/dbconnect.php");
require("inc/secure_page.php");
require("../inc/tracker.php");

// Includes
require("../inc/config.php");
require("inc/lang.php");

// Get passed-in vars
$nLibraryName = (isset($_GET['t']) ? $_GET['t'] : NULL);
$nLibraryNameToPass = urlencode($nLibraryName);

if(!$nLibraryName){ $nLibraryName = nGetFirstImageLibraryName(); $nLibraryNameToPass = $nLibraryName; }
if(!$nLibraryName){ $nLibraryName = _("None"); $nLibraryNameToPass = $nLibraryName; }

$nULAddStyle = "";
$nTotalResults = nGetLibraryCount();
if($nTotalResults>20){ $nULAddStyle = "width:540px;"; }
if($nTotalResults>30){ $nULAddStyle = "width:800px;"; }
if($nTotalResults>50){ $nULAddStyle = "width:1070px;"; }
?>
<?php include("inc/nav/header.php"); ?>

<div id="titlediv">
    <div class="clearfix container" id="pattern">
        <div class="row">
            <div class="col_12">
                <ul class="breadcrumbs hor-list">
                    <li><a href="home.php"><?php echo _("Dashboard"); ?></a></li>
                    <li><a href="library_images.php"><?php echo _("Image Library"); ?></a></li>
                </ul>
                <h1><?php echo _("Image Library"); ?></h1>
            </div>
        </div>
    </div>
</div>

<div class="container" id="actualbody">

	<div class="row clearfix">
	    <div class="widget clearfix" style="min-height:400px;">
			<div class="view-switcher">
			    <h2><span id="ajaxImagesTitle"><?php echo $nLibraryName;?></span><a href="javascript:;">&darr;</a></h2>
			    <ul style="<?php echo $nULAddStyle;?>">
					<?php echo nGetImageLibraries();?>
			    </ul>
			</div>
			<div class="widget_inside">
				<div style="text-align:right; margin-top:-60px;">
				    <a href="library_images_manage.php" class="icon" data-icon-primary="ui-icon-folder-collapsed"><?php echo _("Manage Image Libraries"); ?></a>
				</div>
				<span id="notify" class="notification done" style="display:none;"></span>
				<div class="col_12" id="ajaxImages" style="margin-top:20px;"></div>
	        </div>
	    </div>
	</div>
    
</div>

<script>
// load external content
function nLoadAjaxImages(){
	loadContentToID("#ajaxImages","list/images.php?t=<?php echo $nLibraryNameToPass;?>");
}
$(function(){
	nLoadAjaxImages();
});
// Handle image callbacks
editImage = function(id){
	var xURL = "dialog/image_edit.php?id="+id;
	var xTitle = "Edit Image";
	$.colorbox({ href:xURL, title:xTitle, overlayClose:false, opacity:0.4, maxWidth:850, initialWidth:80, initialHeight:80 });
}
unlinkImage = function(id){
	var xURL = "dialog/image_unlink.php?id="+id;
	var xTitle = "Unlink Image";
	$.colorbox({ href:xURL, title:xTitle, overlayClose:false, opacity:0.4, maxWidth:850, initialWidth:80, initialHeight:80 });
}
deleteImage = function(id){
	var xURL = "dialog/image_delete.php?id="+id;
	var xTitle = "Delete Image";
	$.colorbox({ href:xURL, title:xTitle, overlayClose:false, opacity:0.4, maxWidth:850, initialWidth:80, initialHeight:80 });
}
</script>

<?php include("inc/nav/footer.php") ?>
<?php
function nGetLibraryCount(){
	global $DBName, $Link;
	$nTotalResults = 0;
	$Query = "SELECT nID,nName FROM nLibrary ORDER BY nName";
	mysql_select_db($DBName); $Result = mysql_query($Query,$Link);
	$nTotalResults = mysql_num_rows($Result);
	return $nTotalResults;
}
function nGetImageLibraries(){
	global $DBName, $Link;
	$nTable = $nLIAddStyle = "";
	$nTotalResults = nGetLibraryCount();
	if($nTotalResults>30){ $nLIAddStyle = "float:left; width:240px; padding-right:25px;"; }
	$nTable.="<li><a href=\"javascript:;\" onClick=\"loadTable('#ajaxImages','list/images.php?t=','All images');\">- View all -</a></li>";
	$Query = "SELECT nID,nName FROM nLibrary ORDER BY nName";
	mysql_select_db($DBName); $Result = mysql_query($Query,$Link);
	while ($Row = mysql_fetch_array($Result)){
		$nLibraryID = $Row["nID"];
		$nName = $Row["nName"];
		$nNameToPass = urlencode($nName);
		$nTable.="<li style=\"$nLIAddStyle\"><a href=\"javascript:;\" onClick=\"loadTable('#ajaxImages','list/images.php?t=$nNameToPass','$nName');\">$nName</a></li>";
	}
	return $nTable;
}
function nGetFirstImageLibraryName(){
	global $DBName, $Link;
	$nName = "";
	$Query = "SELECT nID,nName FROM nLibrary ORDER BY nID";
	mysql_select_db($DBName); $Result = mysql_query($Query,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nName = $Row["nName"];
	}
	return $nName;
}
?>
<?php
// disconnect from mysql
mysql_close($Link);
?>