<?php
/*
 * This file is part of a larger software package. Please read the License file 
 * in the root of this installation for terms of usage and distribution.
 * 
 * @author The Web Pro Miami, Inc. <info@thewebpro.com>
 * @copyright The Web Pro Miami, Inc. <info@thewebpro.com>, http://www.thewebpro.com/
 * 
 * CORE: manage/page_edit.php - version 1.0c
 * 1.0c - Allowed "View Page settings" link to show even if overridden by another settings link (to always allow access to pages settings)
*/

$nSecureMe = 1;

// Secure and connect
require("../inc/dbconnect.php");
require("inc/secure_page.php");
require("../inc/tracker.php");

// bring in other required files
require("../inc/config.php");
require("inc/lang.php");
require("../inc/tmplutil.php");
require("inc/imgedit.php");

// Get passed-in vars
$nRecID = (isset($_GET['id']) ? $_GET['id'] : NULL);

// if limited user, get page access to apply limitations
// if trying to access a page w/o authorization, kick them out
if(!$nAdminAccess){ $nPageIDAccessARRAY = nGetPageIDAccessARRAY($nUnencUser); }
if(!$nAdminAccess && !in_array($nRecID,$nPageIDAccessARRAY)){
	header ("Location: index.php?msg=4");
	exit;
}
$nPagePath = nGetPagePath($nRecID);
$nPageName = nGetPageName($nRecID);
$nSectionID = nGetSectionID($nRecID);
$nPageType = nGetPageType($nRecID);
$nAllowMultiple = nGetAllowMultiple($nPageType);
?>
<?php include("inc/nav/header.php"); ?>

<div id="titlediv">
    <div class="clearfix container" id="pattern">
        <div class="row">
            <div class="col_12">
                <ul class="breadcrumbs hor-list">
                    <li><a href="home.php"><?php echo _("Dashboard"); ?></a></li>
                    <li><a href="pages.php"><?php echo _("Pages"); ?></a></li>
					<li><a href="#"><?php echo _("Edit Page"); ?></a></li>
                </ul>
                <h1><?php echo _("Edit"); ?> <?php if($nPageType=="Template"){?><?php echo _("Template"); ?><?php } else { ?><?php echo _("Page"); ?><?php } ?></h1>
            </div>
        </div>
    </div>
</div>

<div class="container" id="actualbody">
	<div class="row clearfix">
		
		<div class="col_9">
			<div class="widget clearfix">
			
				<div class="view-switcher">
				    <h2><span id="categoriesTableTitle"><?php echo $nPageName;?></span></h2>
				</div>
				<div class="widget_inside">
					<div style="text-align:right; margin-top:-60px;">
						<a href="dialog/component_add.php?id=<?php echo $nRecID;?>" title="<?php echo _("Add New Component"); ?>" class="modal icon" data-icon-primary="ui-icon-plus"><?php echo _("Add New Component"); ?></a>
					</div>
					<span id="notify" class="notification done" style="display:none;"></span>
					<div id="ajaxPageEdit" style="margin-top:20px;"></div>
		        </div>
				
			</div>
		</div>
		
		<div class="col_3 last">
		      
			  <div class="widget clearfix">
		          <h2><?php echo _("Tools"); ?></h2>
		          <div class="widget_inside">
				  
					<?php if($nPageType=="Template"){?>
					<p>
						<a href="<?php echo $nPagePath;?>" target="_blank"><?php echo _("View this template on website"); ?><img src="img/external.png" alt="" width="16" height="16" border="0" style="margin:0 0 -3px 4px;"></a></li>
					</p><BR><BR>
					<h3><?php echo _("Template Tags"); ?></h3>
					<div id="secondary_menu">
						<ul>
							<li style="padding:20px 0px;"><?php echo _("You can use the following tags in any of the components of your template:"); ?><BR><BR><strong>[#Title#]</strong> - <?php echo _("Will be replaced with the title of the new page."); ?></li>
						</ul>
					</div>
					<?php } else { ?>
					<p>
						<?php echo nGetEditPageLink($nRecID);?><BR>
						<a href="<?php echo $nPagePath;?>" target="_blank"><?php echo _("View this page on website"); ?><img src="assets/images/icons/external.png" alt="" width="16" height="16" border="0" style="margin:0 0 -3px 4px;"></a><BR>
						<?php if($nAllowMultiple){?>
						<a href="dialog/page_duplicate.php?id=<?php echo $nRecID;?>" title="Duplicate Page" class="modal"><?php echo _("Duplicate this page"); ?></a><BR>
						<a href="dialog/page_make_template.php?id=<?php echo $nRecID;?>" title="Convert Page To Template" class="modal"><?php echo _("Convert this page to a template"); ?></a><BR>
						<?php } ?>
					</p>
					<?php } ?>
					
				</div>
			</div>
			<BR><BR><BR>
			
			<div class="widget clearfix">
				<h2><?php echo _("Related Pages"); ?></h2>
		        <div class="widget_inside">
					
					<p><?php echo nGetPages($nSectionID);?></p>
					
				</div>
			</div>
			<BR><BR><BR>
			
			<?php if($nAllowMobile){ ?>
			<div class="widget clearfix">
				<h2><?php echo _("Mobile Version"); ?></h2>
		        <div class="widget_inside">
					
					<div id="mobileEditor" style="padding-bottom:10px;">
						<div id="ajaxMobileEdit" style="padding:0;">
							<?php echo _("Loading..."); ?>
						</div>
					</div>
					
					<div align="center"><button onClick="$('#tabMobilePreview').show();" class="button black small"><?php echo _("View Mobile Preview"); ?></button></div>
					
				</div>
			</div>
			<?php } ?>
			
			
		</div>

	</div>
</div>

<div id="tabMobilePreview" style="display:none;">
	<div id="delete" style="position:absolute; top:12px; right:12px;"><a href="javascript:;" onClick="$('#tabMobilePreview').hide();"><img src="assets/images/icons/icon_delete.png" alt="" width="23" height="23" border="0" id="img_$nID"></a></div>
	<iframe src="<?php echo tmplGetPageLinkPath($nRecID,array("MOBILE=1"));?>" name="nMobilePreview" id="nMobilePreview" width="340" height="562" marginwidth="0" marginheight="0" frameborder="0"></iframe>
</div>
<script>
$(function() {
	$( "#tabMobilePreview" ).draggable();
});
</script>

<script>
	// load external content
	function nLoadPageModulesTable(){
		loadContentToID("#ajaxPageEdit","list/page_components.php?id=<?php echo $nRecID;?>");
		loadContentToID("#ajaxMobileEdit","list/mobile_components.php?id=<?php echo $nRecID;?>");
	}
	$(function(){
		nLoadPageModulesTable();
		$( "#tabs" ).tabs();
	});
	var mobileTabOpen = false;
	function toggleMobile(){
		if(!mobileTabOpen){
			loadContent('ajaxPageEdit','list/mobile_components.php?id=<?php echo $nRecID;?>');
			$('#mobileLink').addClass("selected");
			$('#mobileLinkText').html("Close Mobile");
			mobileTabOpen = true;
		} else {
			loadContent('ajaxPageEdit','list/page_components.php?id=<?php echo $nRecID;?>');
			$('#mobileLink').removeClass("selected");
			$('#mobileLinkText').html("Mobile Version");
			mobileTabOpen = false;
		}
	}
	nReloadMobile = function(){
		$('#nMobilePreview').attr('src', function(i, val){ return val; });
	}
</script>
<!-- Added for any components that use it so they don't break the system //-->
<script type="text/javascript" src="http://maps.googleapis.com/maps/api/js?sensor=false"></script>

<?php include("inc/nav/footer.php") ?>
<?php
function nGetPagePath($nPageID){
	global $DBName,$Link,$nPermalinks,$nFullSitePath;
	if(!$nPageID){ return; }
	$nPagePath = "";
	$nSQL = "SELECT nType,nTitle,nNavTitle FROM nPage WHERE nID=$nPageID LIMIT 1";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nType = $Row["nType"];
		$nTitle = $Row["nTitle"];
		$nNavTitle = $Row["nNavTitle"];
	}
	switch($nType){
		case "Homepage": $nPagePath = $nFullSitePath; break;
		case "Search": $nPagePath = $nFullSitePath."search.php"; break;
		case "Link": $nPagePath = $nTitle; break;
		default:
			if($nPermalinks){
				$nPageNameForPath = nPrepareNameForPath($nNavTitle); // for mod-rewrite
				$nPagePath = $nPageID."/".$nPageNameForPath.".html"; // for mod-rewrite
				$nPagePath = $nFullSitePath.$nPagePath;
			} else {
				$nPagePath = $nFullSitePath.strtolower($nType).".php?id=$nPageID";
			}
			break;
	}
	// if($nPagePath){ $nPagePath = "../$nPagePath"; }
	return $nPagePath;
}

function nPrepareNameForPath($nName){
	if(!$nName){ return; }
	$nName = str_replace(" ","-",$nName);
	$nRemoveARRAY = array(".",",",";",":","'","!","$","#","?","&","*","%","@","(",")","/","\\","<",">");
	$nName = str_replace($nRemoveARRAY,"",$nName);
	$nName = str_replace("--","-",$nName);
	return $nName;
}

function nGetAllowMultiple($nPageType){
	global $DBName,$Link;
	if(!$nPageType){ return; }
	$nAllowMultiple = "";
	$nSQL = "SELECT nAllowMultiple FROM nPageType WHERE nCode='$nPageType' LIMIT 1";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nAllowMultiple = $Row["nAllowMultiple"];
	}
	return $nAllowMultiple;
}

function nGetPageIDAccessARRAY($ValidUser){
	global $DBName,$Link;
	if(!$ValidUser){ return; }
	// Get user ID
	$nSQL = "SELECT nID FROM nEditor WHERE nUser='$ValidUser' LIMIT 1";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nEditorID = $Row["nID"];
	}
	$nDataARRAY = array();
	$nSQL = "SELECT nPageID FROM xEditorPage WHERE nEditorID=$nEditorID";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nPageID = $Row["nPageID"];
		$nDataARRAY[] = $nPageID;
	}
	return $nDataARRAY;
}

function nGetSectionID($nPageID){
	global $DBName,$Link;
	if(!$nPageID){ return; }
	$nSQL = "SELECT nSectionID FROM nPage WHERE nID=$nPageID LIMIT 1";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nSectionID = $Row["nSectionID"];
	}
	return $nSectionID;
}

function nGetPages($nSectionID){
	global $DBName,$Link,$nAdminAccess,$nPageIDAccessARRAY,$_SERVER,$nFullSitePath;
	if($nSectionID===""){ return ""; }
	$nBrowserType = $_SERVER["HTTP_USER_AGENT"];
	$nIsIE = strpos($nBrowserType," MSIE ");
	$nCurrRec = 0;
	$nTable = "";
	$nSQL = "SELECT * FROM nPage WHERE nSectionID=$nSectionID ORDER BY nOrderID";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
		$nCurrRec++;
		$nID = $Row["nID"];
		$nNavTitle = $Row["nNavTitle"];
		$nTitle = $Row["nTitle"];
		$nBGColor = $Row["nBGColor"];
		$nBaseColor = $Row["nBaseColor"];
		$nBGImgID = $Row["nBGImgID"];
		$nType = $Row["nType"];
		
		if(!$nBGColor){ $nBGColor = "#007bb6"; } // default blue
		switch($nType){
			case "Homepage": $nAddIcon = "<div id=\"editMini\"><img src=\"assets/images/icons/icon_home.png\" width=\"26\" height=\"26\" border=\"0\"></div>"; break;
			case "Search": $nAddIcon = "<div id=\"editMini\"><img src=\"assets/images/icons/icon_search.png\" width=\"26\" height=\"26\" border=\"0\"></div>"; break;
			case "Template": $nAddIcon = "<div id=\"editMini\"><img src=\"assets/images/icons/icon_template.png\" width=\"26\" height=\"26\" border=\"0\"></div>"; break;
			case "Link": $nAddIcon = "<div id=\"editMini\"><img src=\"assets/images/icons/icon_link.png\" width=\"26\" height=\"26\" border=\"0\"></div>"; break;
			default: $nAddIcon = ""; break;
		}
		$nHoverCODE = "";
		
		$nIcnBGClr = $nBGColor;
		$nIcnTxt = $nNavTitle;
		$nIcnTag = "<div class=\"boxIconS\" style=\"background-color:$nIcnBGClr;\"><p>$nIcnTxt</p></div>";
		
		if(!$nAdminAccess && in_array($nID,$nPageIDAccessARRAY)){ $nHasPageAccess = 1; } else { $nHasPageAccess = 0; }
		if($nAdminAccess){ $nHasPageAccess = 1; }
		if($nHasPageAccess){
			if($nType=="Link"){
				$nIcnTag = "<a href=\"dialog/page_add.php?id=$nID\" title=\""._("Edit Page Settings")."\" class=\"modal\">$nIcnTag</a>";
			} else {
				$nIcnTag = "<a href=\"page_edit.php?id=$nID\" title=\"$nIcnTxt\">$nIcnTag</a>";
			}
			$nTable.= <<<CODE
				<div id="icon_$nID" class="pageIcon" $nHoverCODE>$nIcnTag<div id="editStamps" style="width:30px;">$nAddIcon</div></div>
CODE;
		}
	}
	return $nTable;
}
function nGetTranslation($nLangCode,$nItemID,$nField,$nType){
	global $DBName,$Link;
	if(!$nLangCode || !$nItemID || !$nField || !$nType){ return; }
	$nTranslation = "";
	$Query = "SELECT $nField AS nField FROM nTranslate WHERE nLang='$nLangCode' AND nItemID='$nItemID' AND nType='$nType'";
	mysql_select_db($DBName); $Result = mysql_query($Query,$Link);
	if ($Row = mysql_fetch_array($Result)) {
		$nTranslation = $Row["nField"];
	}
	return $nTranslation;
}
function nGetEditPageLink($nPageID){
	global $DBName,$Link;
	if(!$nPageID){ return; }
	// Default page link
	$nPageLink = "<a href=\"dialog/page_add.php?id=$nPageID\" title=\""._("Edit page settings")."\" class=\"modal\">"._("Edit page settings")."</a>";
	// Add new column to xPage table if it doesn't exist (fix for error in 1.14 release)
	nAddColIfNotExist("xPage","nRecEditPath","VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL");
	$nSQL = "SELECT nRecType,nRecEditPath FROM xPage WHERE nPageID=$nPageID LIMIT 1";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	if($Row = mysql_fetch_array($Result)){
		$nRecType = ucwords($Row["nRecType"]);
		$nRecEditPath = $Row["nRecEditPath"];
		if($nRecEditPath){ $nPageLink.= "<BR><a href=\"$nRecEditPath\" title=\""._("Edit $nRecType settings")."\">"._("Edit $nRecType settings")."</a>"; }
	}
	return $nPageLink;
}
function nAddColIfNotExist($nTable,$nColumn,$nColumnAttr = "VARCHAR(255) NOT NULL" ){
    global $DBName,$Link;
	$nExists = false;
	$nSQL = "SHOW COLUMNS FROM $nTable";
	mysql_select_db($DBName); $Result = mysql_query($nSQL,$Link);
	while($Row = mysql_fetch_array($Result)){
        if($Row['Field'] == $nColumn){
            $nExists = true; break;
        }
    }      
    if(!$nExists){
        mysql_query("ALTER TABLE $nTable ADD $nColumn $nColumnAttr");
    }
}
?>
<?php require("../inc/db_close.php"); ?>

